/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.rtmp;

import android.util.Log;
import com.adobe.ane.h264videopublish.rtmp.RTMPConnection;
import com.adobe.ane.h264videopublish.rtmp.task.RTMPConnectionTask;
import com.adobe.ane.h264videopublish.rtmp.task.RTMPDisconnectionTask;
import com.macromedia.fcs.client.NetStream;
import java.util.concurrent.LinkedBlockingQueue;

public class RTMPStreamPublisher
extends Thread {
    private static final String TAG = "RTMPStreamPublisher";
    private static LinkedBlockingQueue<byte[]> queue;
    private NetStream netStream;
    private RTMPConnection rtmpConnection = RTMPConnection.getInstance();
    private String streamName;
    private String streamType;

    public RTMPStreamPublisher(String string, String string2, String string3, String string4) {
        this.streamName = string4;
        this.streamType = "live";
        queue = new LinkedBlockingQueue();
        this.initializeConnection(string, string2, string3);
    }

    public void initializeConnection(String string, String string2, String string3) {
        new EstablishConnection().execute(new String[]{string, string2, string3});
    }

    public void startPublishing(String string, String string2) {
        this.rtmpConnection.initStream();
        this.netStream = new NetStream(this.rtmpConnection.getNetConnection());
        System.out.println("Hello streamName:" + string);
        this.netStream.publish(string, string2);
        this.start();
    }

    @Override
    public void run() {
        while (RTMPConnection.getInstance().isConnected()) {
            try {
                this.sendMessage(queue.take());
            }
            catch (InterruptedException interruptedException) {
                Log.e((String)TAG, (String)"Hello, Exception occurred while sending the packet to the media server", (Throwable)interruptedException);
            }
        }
    }

    private void sendMessage(byte[] byArray) {
        Log.d((String)TAG, (String)("sendMessage: " + byArray.length));
        System.out.println("Hello, adding data to Queue message :");
        this.netStream.sendMessage((double)System.currentTimeMillis(), 9, byArray);
    }

    public static void addDataToQueue(byte[] byArray) {
        try {
            if (RTMPConnection.getInstance().isConnected()) {
                queue.put(byArray);
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Hello, adding data to Queue executed :");
            Log.e((String)TAG, (String)"Exception occurred when adding packaged data to queue.", (Throwable)interruptedException);
        }
    }

    public void endPublishing() {
        new RTMPDisconnectionTask().execute(new Void[0]);
    }

    public NetStream getNetStream() {
        return this.netStream;
    }

    public class EstablishConnection
    extends RTMPConnectionTask {
        private static final String TAG = "EstablishConnection";

        protected void onPostExecute(Boolean bl) {
            System.out.println("Hello, executed :" + bl);
            RTMPStreamPublisher.this.startPublishing(RTMPStreamPublisher.this.streamName, RTMPStreamPublisher.this.streamType);
        }
    }
}

