/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.preview;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.adobe.ane.h264videopublish.callback.CameraPreviewCallback;
import com.adobe.ane.h264videopublish.camera.CameraWrapper;
import com.adobe.ane.h264videopublish.encode.VideoEncoder;
import java.io.IOException;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "CameraPreview";
    private static final int ENC_BIT_RATE = 6000;
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private CameraPreviewCallback previewCallback;
    private byte[] mImageCallbackBuffer;
    private VideoEncoder videoEncoder;

    public CameraPreview(Context context, Camera camera) {
        super(context);
        this.mCamera = camera;
        this.mImageCallbackBuffer = new byte[CameraWrapper.getCameraParameters().getPreviewSize().width * CameraWrapper.getCameraParameters().getPreviewSize().height * 3 / 2];
        this.videoEncoder = new VideoEncoder(CameraWrapper.getCameraParameters().getPreviewSize().width, CameraWrapper.getCameraParameters().getPreviewSize().height);
        this.previewCallback = new CameraPreviewCallback(this.videoEncoder, camera);
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.mHolder.setType(3);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        try {
            this.mCamera.addCallbackBuffer(this.mImageCallbackBuffer);
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.previewCallback);
            this.mCamera.setPreviewDisplay(surfaceHolder);
            this.mCamera.startPreview();
        }
        catch (IOException iOException) {
            Log.d((String)TAG, (String)("Error setting camera preview: " + iOException.getMessage()));
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (this.mHolder.getSurface() == null) {
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mCamera.addCallbackBuffer(this.mImageCallbackBuffer);
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this.previewCallback);
            this.mCamera.setPreviewDisplay(this.mHolder);
            this.mCamera.startPreview();
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("Error starting camera preview: " + exception.getMessage()));
        }
    }

    public void publishingStarted(boolean bl) {
        this.previewCallback.setPublishData(bl);
    }
}

