/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.preview;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.adobe.ane.h264videopublish.callback.CameraPreviewCallback;
import com.adobe.ane.h264videopublish.camera.CameraWrapper;
import com.adobe.ane.h264videopublish.encode.VideoEncoder;
import com.adobe.ane.h264videopublish.extension.H264PublishExtension;
import com.adobe.fre.FREContext;
import java.io.IOException;

public class CameraContainer {
    private TextureView mTextureView;
    private ImageView imageButton;
    private ImageView pauseButton;
    private CameraWrapper cameraWrapper;
    private Activity context;
    private int x;
    private int y;
    private int width;
    private int height;
    private VideoEncoder videoEncoder;
    private CameraPreviewCallback previewCallback;
    private FREContext freContext;
    private boolean paused;
    private static CameraContainer cameraContainer;
    private static int cameraState;

    private CameraContainer(Activity activity) {
        this.context = activity;
    }

    public static CameraContainer getInstance(Activity activity) {
        if (cameraContainer == null) {
            cameraContainer = new CameraContainer(activity);
        }
        return cameraContainer;
    }

    public void initialize() {
        this.mTextureView = new TextureView((Context)this.context);
        this.cameraWrapper = CameraWrapper.getInstance(cameraState, (Context)this.context);
        this.videoEncoder = new VideoEncoder(CameraWrapper.getCameraParameters().getPreviewSize().width, CameraWrapper.getCameraParameters().getPreviewSize().height);
        CameraContainer cameraContainer = this;
        this.previewCallback = new CameraPreviewCallback(this.videoEncoder, cameraContainer.cameraWrapper.getCamera());
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
                CameraContainer.this.cameraWrapper;
                Camera.Size size = CameraWrapper.getCamera().getParameters().getPreviewSize();
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n, n2);
                layoutParams.leftMargin = CameraContainer.this.x;
                layoutParams.topMargin = CameraContainer.this.y;
                CameraContainer.this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                try {
                    CameraContainer.this.cameraWrapper;
                    CameraWrapper.getCamera().setPreviewTexture(surfaceTexture);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CameraContainer.this.cameraWrapper;
                CameraWrapper.getCamera().setPreviewCallback((Camera.PreviewCallback)CameraContainer.this.previewCallback);
                CameraContainer.this.cameraWrapper;
                CameraWrapper.getCamera().startPreview();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
                CameraContainer.this.cameraWrapper;
                CameraWrapper.getCamera().stopPreview();
                CameraContainer.this.cameraWrapper;
                CameraWrapper.getCamera().setPreviewCallback(null);
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        });
    }

    public void addView() {
        this.context.addContentView((View)this.mTextureView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(this.width, this.height, this.x, this.y));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(120, 120);
        layoutParams.leftMargin = this.x + this.width - 120;
        layoutParams.topMargin = this.y + 20;
        this.imageButton = new ImageView((Context)this.context);
        int n = this.freContext.getResourceId("drawable.switch_camera");
        Drawable drawable = this.context.getResources().getDrawable(n);
        this.imageButton.setImageDrawable(drawable);
        this.imageButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.pauseButton = new ImageView((Context)this.context);
        int n2 = this.freContext.getResourceId("drawable.pause_camera");
        Drawable drawable2 = this.context.getResources().getDrawable(n2);
        this.pauseButton.setImageDrawable(drawable2);
        this.pauseButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean bl = CameraContainer.this.paused;
                cameraContainer.toggleCamera();
                cameraContainer.cleanUp();
                CameraContainer.this.cameraWrapper;
                CameraWrapper.releaseCamera();
                CameraContainer.this.videoEncoder.releaseEncoder();
                FREContext fREContext = CameraContainer.this.freContext;
                CameraContainer.cameraContainer = CameraContainer.getInstance(CameraContainer.this.context);
                cameraContainer.setPosition(CameraContainer.this.x, CameraContainer.this.y, CameraContainer.this.width, CameraContainer.this.height);
                cameraContainer.initialize();
                cameraContainer.setFreContext(fREContext);
                cameraContainer.addView();
                if (H264PublishExtension.context.isPublishing()) {
                    if (bl) {
                        cameraContainer.togglePauseCamera();
                    }
                    cameraContainer.publishingStarted(true);
                }
            }
        });
        if (CameraWrapper.frontCameraAvailable) {
            ((ViewGroup)this.mTextureView.getParent()).addView((View)this.imageButton, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void cleanUp() {
        try {
            if (this.mTextureView != null) {
                ((ViewGroup)this.mTextureView.getParent()).removeView((View)this.mTextureView);
            }
            if (this.imageButton != null) {
                ((ViewGroup)this.imageButton.getParent()).removeView((View)this.imageButton);
            }
            if (this.paused) {
                ((ViewGroup)this.pauseButton.getParent()).removeView((View)this.pauseButton);
            }
            this.paused = false;
            this.mTextureView = null;
            cameraContainer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVisibility(int n) {
        if (this.mTextureView != null) {
            this.mTextureView.setVisibility(n);
            this.mTextureView.bringToFront();
        }
        if (this.imageButton != null) {
            this.imageButton.setVisibility(n);
            this.imageButton.bringToFront();
        }
        if (this.paused) {
            this.pauseButton.setVisibility(n);
        }
    }

    public CameraWrapper getCameraWrapper() {
        return this.cameraWrapper;
    }

    public void setCameraWrapper(CameraWrapper cameraWrapper) {
        this.cameraWrapper = cameraWrapper;
    }

    public void setPosition(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void publishingStarted(boolean bl) {
        this.previewCallback.setPublishData(bl);
    }

    public void togglePauseCamera() {
        boolean bl = this.paused = !this.paused;
        if (this.paused) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(120, 120);
            layoutParams.leftMargin = this.x + 20;
            layoutParams.topMargin = this.y + 20;
            ((ViewGroup)this.mTextureView.getParent()).addView((View)this.pauseButton, (ViewGroup.LayoutParams)layoutParams);
        } else {
            ((ViewGroup)this.mTextureView.getParent()).removeView((View)this.pauseButton);
        }
        this.previewCallback.togglePauseCamera();
    }

    public void toggleCamera() {
        cameraState = cameraState == 1 ? 0 : 1;
    }

    public static void releaseCamera() {
        CameraWrapper.releaseCamera();
    }

    public void startCameraPreviewWhenInvisible() {
        System.out.println("Updated called when invisible");
        CameraContainer cameraContainer = this;
        Camera.Size size = cameraContainer.cameraWrapper.getCamera().getParameters().getPreviewSize();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.width, this.height);
        layoutParams.leftMargin = this.x;
        layoutParams.topMargin = this.y;
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        try {
            this.mTextureView.setVisibility(0);
            CameraContainer cameraContainer2 = this;
            cameraContainer2.cameraWrapper.getCamera().setPreviewTexture(this.mTextureView.getSurfaceTexture());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CameraContainer cameraContainer3 = this;
        cameraContainer3.cameraWrapper.getCamera().setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
        CameraContainer cameraContainer4 = this;
        cameraContainer4.cameraWrapper.getCamera().startPreview();
    }

    public void setFreContext(FREContext fREContext) {
        this.freContext = fREContext;
    }

    static {
        cameraState = 1;
    }
}

