/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.extension.context;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import com.adobe.ane.h264videopublish.camera.CameraWrapper;
import com.adobe.ane.h264videopublish.extension.function.EndPublishingFunction;
import com.adobe.ane.h264videopublish.extension.function.HidePodFunction;
import com.adobe.ane.h264videopublish.extension.function.PauseCameraFunction;
import com.adobe.ane.h264videopublish.extension.function.SetEncoderParameters;
import com.adobe.ane.h264videopublish.extension.function.SetPositionFunction;
import com.adobe.ane.h264videopublish.extension.function.ShowPodFunction;
import com.adobe.ane.h264videopublish.extension.function.StartPublishFunction;
import com.adobe.ane.h264videopublish.extension.function.ToggleCameraFunction;
import com.adobe.ane.h264videopublish.preview.CameraPreview;
import com.adobe.ane.h264videopublish.rtmp.RTMPStreamPublisher;
import com.adobe.fre.FREContext;
import com.adobe.fre.FREFunction;
import java.util.HashMap;
import java.util.Map;

public class H264PublishContext
extends FREContext {
    private ViewGroup container = null;
    private CameraWrapper cameraWrapper;
    private CameraPreview cameraPreview;
    private AbsoluteLayout.LayoutParams layoutParams;
    private RTMPStreamPublisher rtmpStreamPublisher;
    private boolean publishing;
    private boolean visible;
    private int x = 100;
    private int y = 100;
    private int width = 500;
    private int height = 500;

    public ViewGroup getRootContainer() {
        return (ViewGroup)((ViewGroup)this.getActivity().findViewById(0x1020002)).getChildAt(0);
    }

    public ViewGroup getCameraContainer() {
        if (this.container == null) {
            this.layoutParams = new AbsoluteLayout.LayoutParams(this.x, this.y, this.width, this.height);
            this.container = new AbsoluteLayout((Context)this.getActivity());
            this.container.addView((View)this.getCameraView(), (ViewGroup.LayoutParams)this.layoutParams);
        }
        return this.container;
    }

    public CameraPreview getCameraView() {
        System.out.println("Hello, in getCameraView");
        System.out.println("Hello, cameraWrapper value" + (this.cameraWrapper == null ? "false" : "true"));
        if (this.cameraWrapper == null) {
            this.cameraWrapper = CameraWrapper.getInstance(1, (Context)this.getActivity());
        }
        if (this.cameraPreview == null) {
            H264PublishContext h264PublishContext = this;
            this.cameraPreview = new CameraPreview((Context)this.getActivity(), h264PublishContext.cameraWrapper.getCamera());
        }
        return this.cameraPreview;
    }

    public void toggleCamera() {
        H264PublishContext h264PublishContext = this;
        h264PublishContext.cameraWrapper.toggleCamera();
    }

    public void startPublishing(String string, String string2, String string3, String string4) {
        this.rtmpStreamPublisher = new RTMPStreamPublisher(string, string2, string3, string4);
        this.publishing = true;
    }

    public void endPublishing() {
        this.rtmpStreamPublisher.endPublishing();
        this.rtmpStreamPublisher = null;
        this.publishing = false;
    }

    public Map<String, FREFunction> getFunctions() {
        HashMap<String, FREFunction> hashMap = new HashMap<String, FREFunction>();
        hashMap.put("startPublishing", new StartPublishFunction());
        hashMap.put("stopPublishing", new EndPublishingFunction());
        hashMap.put("toggleCamera", new ToggleCameraFunction());
        hashMap.put("showPod", new ShowPodFunction());
        hashMap.put("hidePod", new HidePodFunction());
        hashMap.put("setPosition", new SetPositionFunction());
        hashMap.put("togglePause", new PauseCameraFunction());
        hashMap.put("setEncoderParameters", new SetEncoderParameters());
        return hashMap;
    }

    public void dispose() {
    }

    public AbsoluteLayout.LayoutParams getLayoutParams() {
        return this.layoutParams;
    }

    public void setLayoutParams(AbsoluteLayout.LayoutParams layoutParams) {
        this.layoutParams = layoutParams;
    }

    public boolean isPublishing() {
        return this.publishing;
    }

    public void setPublishing(boolean bl) {
        this.publishing = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }
}

