/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.encode;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import com.adobe.ane.h264videopublish.encode.AVCFramePackager;
import java.nio.ByteBuffer;

public class VideoEncoder {
    private static final String TAG = "VideoEncoder";
    private static final String MIME_TYPE = "video/avc";
    public static int FRAME_RATE = 15;
    public static int IFRAME_INTERVAL = 90;
    public static int BIT_RATE = 32768;
    private MediaCodec codec;
    private AVCFramePackager packager;
    private byte[] sps;
    private byte[] pps;
    private int height;
    private int width;
    long now;
    long oldnow;
    long i;

    public VideoEncoder(int n, int n2) {
        this.oldnow = this.now = System.nanoTime() / 1000L;
        this.i = 0L;
        Log.d((String)TAG, (String)("video/avc output " + n + "x" + n2));
        this.prepareEncoder(n, n2);
        this.packager = new AVCFramePackager();
    }

    private void prepareEncoder(int n, int n2) {
        this.height = n2;
        this.width = n;
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)n, (int)n2);
        mediaFormat.setInteger("color-format", 21);
        mediaFormat.setInteger("bitrate", BIT_RATE);
        mediaFormat.setInteger("frame-rate", FRAME_RATE);
        mediaFormat.setInteger("i-frame-interval", IFRAME_INTERVAL);
        try {
            this.codec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.codec.configure(mediaFormat, null, null, 1);
        this.codec.start();
    }

    public void encode(byte[] byArray) {
        this.oldnow = this.now;
        this.now = System.nanoTime() / 1000L;
        if (this.i++ > 3L) {
            this.i = 0L;
        }
        try {
            ByteBuffer byteBuffer;
            ByteBuffer[] byteBufferArray = this.codec.getInputBuffers();
            ByteBuffer[] byteBufferArray2 = this.codec.getOutputBuffers();
            int n = this.codec.dequeueInputBuffer(500000L);
            byte[] byArray2 = this.swapYV12toI420(byArray, this.width, this.height);
            if (n >= 0) {
                byteBuffer = byteBufferArray[n];
                byteBuffer.clear();
                byteBuffer.put(byArray2);
                this.codec.queueInputBuffer(n, 0, byArray.length, this.now, 0);
                System.out.println("Seems working fine");
            }
            byteBuffer = new MediaCodec.BufferInfo();
            int n2 = this.codec.dequeueOutputBuffer((MediaCodec.BufferInfo)byteBuffer, 500000L);
            System.out.println("index: " + n2);
            while (n2 >= 0) {
                ByteBuffer byteBuffer2;
                ByteBuffer byteBuffer3 = byteBufferArray2[n2];
                byte[] byArray3 = new byte[((MediaCodec.BufferInfo)byteBuffer).size];
                byteBuffer3.get(byArray3);
                System.out.println("output buffer");
                if (this.sps != null && this.pps != null) {
                    byteBuffer2 = ByteBuffer.wrap(byArray3);
                    byteBuffer2.putInt(((MediaCodec.BufferInfo)byteBuffer).size - 4);
                    System.out.println("parsing data packets");
                    this.packager.frameReceived(byArray3, 0L, byArray3.length);
                } else {
                    byteBuffer2 = ByteBuffer.wrap(byArray3);
                    if (byteBuffer2.getInt() == 1) {
                        System.out.println("parsing sps/pps");
                    } else {
                        System.out.println("something is amiss?");
                    }
                    int n3 = 0;
                    while (byteBuffer2.get() != 0 || byteBuffer2.get() != 0 || byteBuffer2.get() != 0 || byteBuffer2.get() != 1) {
                    }
                    n3 = byteBuffer2.position();
                    this.sps = new byte[n3 - 8];
                    System.arraycopy(byArray3, 4, this.sps, 0, this.sps.length);
                    this.pps = new byte[byArray3.length - n3];
                    System.arraycopy(byArray3, n3, this.pps, 0, this.pps.length);
                    if (null != this.packager) {
                        this.packager.avcParametersSetsEstablished(this.sps, this.pps);
                    }
                }
                this.codec.releaseOutputBuffer(n2, false);
                n2 = this.codec.dequeueOutputBuffer((MediaCodec.BufferInfo)byteBuffer, 0L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void releaseEncoder() {
        if (this.codec != null) {
            this.codec.stop();
            this.codec.release();
            this.codec = null;
        }
    }

    public MediaCodec getCodec() {
        return this.codec;
    }

    public byte[] swapYV12toI420(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n * n2;
        int n5 = n4 / 4;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        for (n3 = 0; n3 < n5; ++n3) {
            byte by;
            byArray2[n4 + n3 * 2] = by = byArray[n4 + n5 + n3 - 32 - 320];
            byArray2[n4 + n3 * 2 + 1] = byArray[n4 + n3 - 32 - 320];
        }
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        for (n3 = 0; n3 < n5; ++n3) {
            byArray2[n4 + n3 * 2] = byArray[n4 + n3 + n5];
            byArray2[n4 + n3 * 2 + 1] = byArray[n4 + n3];
        }
        return byArray2;
    }
}

