/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.encode;

import com.adobe.ane.h264videopublish.encode.EncodedFrameListener;
import com.adobe.ane.h264videopublish.rtmp.RTMPStreamPublisher;

public class AVCFramePackager
implements EncodedFrameListener {
    private static final String TAG = "AVCFramePackager";
    private byte[] sps = null;
    private byte[] pps = null;
    private byte[] stapa = null;
    public static final byte FLV_CODECID_H264 = 7;
    public static final byte FRAME_TYPE_KEY = 16;
    public static final int AVC_PACKET_TYPE_IDX = 1;
    public static final int AVC_PACKET_TYPE_AVCC = 0;
    public static final int AVC_PACKET_TYPE_SAMPLE = 1;
    public static final int AVC_PACKET_TYPE_EOS = 2;
    public static final int AVC_PACKET_COMP_TIME_IDX = 2;
    public static final int AVC_PACKET_COMP_TIME_LEN = 3;
    public static final int AVC_PACKET_data_LEN = 5;
    public static final byte NALU_TYPE_MASK = 31;
    public static final int FLAGS_SIZE = 5;
    public static final byte FLV_VIDEO_FRAMETYPE_OFFSET = 4;
    public static final byte FLV_FRAME_KEY = 16;
    public static final byte FLV_FRAME_INTER = 32;
    public static final byte FLV_FRAME_DISP_INTER = 48;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void frameReceived(byte[] byArray, long l, int n) {
        int n2;
        int n3 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
        int n4 = byArray[4] & 0x1F;
        System.out.println("frameReceived is called with size: " + n);
        System.out.println("frameReceived is called with naluLength: " + n3);
        System.out.println("frameReceived is called with type: " + n4);
        System.out.println("data packet ");
        for (n2 = 0; n2 < 10; ++n2) {
            System.out.print(byArray[n2] + " ");
        }
        System.out.println("");
        n2 = 0;
        boolean bl = n4 == 7 || n4 == 8 || n4 == 5;
        n2 = 7;
        switch (n4) {
            case 7: {
                if (this.sps.length != 0) return;
                this.sps = new byte[n - 4];
                System.arraycopy(byArray, 4, this.sps, 0, n - 4);
                return;
            }
            case 8: {
                if (this.pps.length == 0) {
                    this.pps = new byte[n - 4];
                    System.arraycopy(byArray, 4, this.pps, 0, n - 4);
                }
                n2 = (byte)(n2 | 0x10);
                break;
            }
            case 5: {
                n2 = (byte)(n2 | 0x10);
                break;
            }
            default: {
                n2 = (byte)(n2 | 0x20);
            }
        }
        byte[] byArray2 = null;
        if (bl && this.sps.length > 0 && this.pps.length > 0) {
            byArray2 = this.configurationFromSpsAndPps();
            n = byArray2.length;
        }
        byte[] byArray3 = new byte[n + 5];
        byArray3[0] = n2;
        byArray3[1] = (byte)(!bl ? 1 : 0);
        byArray3[2] = 0;
        byArray3[3] = 0;
        byArray3[4] = 0;
        if (bl) {
            if (this.sps.length <= 0 || this.pps.length <= 0) return;
            System.arraycopy(byArray2, 0, byArray3, 5, byArray2.length);
            RTMPStreamPublisher.addDataToQueue(byArray3);
            byte[] byArray4 = new byte[5 + byArray.length];
            System.arraycopy(byArray3, 0, byArray4, 0, 5);
            byArray4[1] = 1;
            System.arraycopy(byArray, 0, byArray4, 5, byArray.length);
            byArray3 = byArray4;
        } else {
            System.arraycopy(byArray, 0, byArray3, 5, n);
        }
        RTMPStreamPublisher.addDataToQueue(byArray3);
    }

    @Override
    public void avcParametersSetsEstablished(byte[] byArray, byte[] byArray2) {
        System.out.println("avcParametersSetsEstablished is called");
        this.pps = byArray2;
        this.sps = byArray;
        if (byArray2 != null && byArray != null) {
            this.stapa = new byte[byArray.length + byArray2.length + 5];
            this.stapa[0] = 24;
            this.stapa[1] = (byte)(byArray.length >> 8);
            this.stapa[2] = (byte)(byArray.length & 0xFF);
            this.stapa[byArray.length + 1] = (byte)(byArray2.length >> 8);
            this.stapa[byArray.length + 2] = (byte)(byArray2.length & 0xFF);
            System.arraycopy(byArray, 0, this.stapa, 3, byArray.length);
            System.arraycopy(byArray2, 0, this.stapa, 5 + byArray.length, byArray2.length);
        }
    }

    private byte[] configurationFromSpsAndPps() {
        byte[] byArray = new byte[6 + this.sps.length + 1 + this.pps.length + 4];
        byArray[0] = 1;
        byArray[1] = this.sps[1];
        byArray[2] = this.sps[2];
        byArray[3] = this.sps[3];
        byArray[4] = -1;
        byArray[5] = -31;
        byArray[6] = (byte)(this.sps.length >> 8);
        byArray[7] = (byte)(this.sps.length & 0xFF);
        System.arraycopy(this.sps, 0, byArray, 8, this.sps.length);
        byArray[8 + this.sps.length] = 1;
        byArray[9 + this.sps.length] = (byte)(this.pps.length >> 8);
        byArray[10 + this.sps.length] = (byte)(this.pps.length & 0xFF);
        System.arraycopy(this.pps, 0, byArray, this.sps.length + 11, this.pps.length);
        return byArray;
    }
}

