/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;

public class CameraWrapper {
    private static final String TAG = "CameraWrapper";
    private static Camera mCamera;
    private static Camera.Parameters mCameraParameters;
    private static CameraWrapper instance;
    private static int cameraFacing;
    public static boolean frontCameraAvailable;

    private CameraWrapper(int n, Context context) {
        if (this.checkCameraHardware(context) && (mCamera = CameraWrapper.getCameraInstance(n)) != null) {
            mCameraParameters = mCamera.getParameters();
            mCameraParameters.setPreviewFormat(842094169);
            mCamera.setParameters(mCameraParameters);
        }
    }

    public static CameraWrapper getInstance(int n, Context context) {
        if (instance != null) {
            return instance;
        }
        return new CameraWrapper(n, context);
    }

    private boolean checkCameraHardware(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    private static Camera getCameraInstance(int n) {
        cameraFacing = n;
        int n2 = Camera.getNumberOfCameras();
        Camera camera = null;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (n2 == 1) {
            camera = CameraWrapper.openCamera(0);
            frontCameraAvailable = false;
        } else {
            frontCameraAvailable = true;
            for (int i = 0; i < n2; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != cameraFacing) continue;
                camera = CameraWrapper.openCamera(i);
            }
        }
        return camera;
    }

    private static Camera openCamera(int n) {
        Camera camera = null;
        try {
            camera = Camera.open((int)n);
        }
        catch (RuntimeException runtimeException) {
            Log.e((String)TAG, (String)("Camera failed to open: " + runtimeException.getLocalizedMessage()));
        }
        return camera;
    }

    public static void toggleCamera() {
        CameraWrapper.releaseCamera();
        if (cameraFacing == 1) {
            CameraWrapper.getCameraInstance(0);
        } else {
            CameraWrapper.getCameraInstance(1);
        }
    }

    public static void releaseCamera() {
        if (mCamera != null) {
            mCamera.release();
            mCamera = null;
        }
    }

    public static int getCameraFacing() {
        return cameraFacing;
    }

    public static Camera getCamera() {
        return mCamera;
    }

    public static Camera.Parameters getCameraParameters() {
        return mCameraParameters;
    }

    static {
        frontCameraAvailable = false;
    }
}

