/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.ane.h264videopublish.callback;

import android.hardware.Camera;
import android.util.Log;
import com.adobe.ane.h264videopublish.encode.VideoEncoder;
import com.adobe.ane.h264videopublish.rtmp.RTMPConnection;

public class CameraPreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = "CameraPreviewCallback";
    private boolean publishData;
    private boolean paused = false;
    long now;
    long oldnow = this.now = System.nanoTime() / 1000L;
    long i = 0L;
    Camera camera;
    VideoEncoder encoder;

    public CameraPreviewCallback(VideoEncoder videoEncoder, Camera camera) {
        System.out.println("Hello, I m in CameraPreviewCallback");
        this.camera = camera;
        this.encoder = videoEncoder;
        this.publishData = false;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (this.publishData) {
            Log.d((String)TAG, (String)("onPreviewFrame invoked - encoding frame: " + byArray.toString()));
            if (!this.paused) {
                this.encoder.encode(byArray);
            }
            camera.addCallbackBuffer(byArray);
        }
    }

    public boolean isPublishData() {
        return this.publishData;
    }

    public void setPublishData(boolean bl) {
        if (bl) {
            while (!RTMPConnection.getInstance().isConnected()) {
                System.out.println("Hello, Waiting for net connection");
            }
        }
        this.publishData = bl;
        if (!bl) {
            this.encoder.releaseEncoder();
        }
    }

    public void togglePauseCamera() {
        this.paused = !this.paused;
    }
}

