/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

public class Util {
    public static URI parseURI(String uristr) {
        String tempstr = uristr;
        String[] splits = Util.split(tempstr, ":");
        if (splits == null) {
            return null;
        }
        if (!(splits[0].equals("rtmp") || splits[0].equals("rtmpt") || splits[0].equals("rtmps"))) {
            return null;
        }
        URI uri = new URI();
        uri.proto = splits[0];
        if (splits[0].equals("rtmps")) {
            uri.isSSL = true;
        }
        if ((tempstr = splits[1].substring(1)).startsWith("//")) {
            splits = Util.split(tempstr, ":");
            if (splits != null) {
                uri.host = splits[0].substring(2);
                tempstr = splits[1];
            } else {
                splits = Util.split(tempstr.substring(2), "/");
                if (splits != null) {
                    uri.host = splits[0];
                    tempstr = splits[1];
                }
            }
        }
        if (tempstr.startsWith(":") && (splits = Util.split(tempstr.substring(1), "/")) != null) {
            try {
                uri.port = Integer.parseInt(splits[0]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            tempstr = splits[1];
        }
        if (!tempstr.startsWith("/")) {
            return null;
        }
        uri.app = tempstr.substring(1);
        return uri;
    }

    public static String[] split(String string, String sep) {
        int pos = string.indexOf(sep);
        if (pos < 0) {
            return null;
        }
        return new String[]{string.substring(0, pos), string.substring(pos)};
    }

    public static void dump(byte[] bytes, int nbytes) {
        int NCHARS = 16;
        StringBuffer sb = new StringBuffer(2 * bytes.length);
        int k = 0;
        for (int i = 0; i < nbytes; ++i) {
            String s = Integer.toString(bytes[i] & 0xFF, 16);
            if (s.length() < 2) {
                s = "0" + s;
            }
            sb.append(s + " ");
            if (i <= 0 || i % NCHARS != NCHARS - 1 && i != nbytes - 1 || (k = i / NCHARS * NCHARS) < 0) continue;
            for (int n = 0; n < NCHARS - i % NCHARS; ++n) {
                sb.append("   ");
            }
            sb.append(" |" + Util.toText(bytes, k, i - k + 1) + "\n");
        }
        System.out.println(sb);
    }

    public static String toText(byte[] bytes, int offset, int length) {
        StringBuffer sb = new StringBuffer(length);
        for (int j = offset; j < offset + length; ++j) {
            char c = '.';
            try {
                char[] cs = new String(bytes, j, 1, "US-ASCII").toCharArray();
                if (Character.isJavaIdentifierStart(cs[0]) || Character.isDigit(cs[0])) {
                    c = cs[0];
                }
            }
            catch (Exception x) {
                c = '?';
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static class URI
    implements Cloneable {
        public String proto;
        public String host;
        public int port = -1;
        public String app;
        public boolean isSSL = false;

        public String toString() {
            String result = this.proto + ":";
            result = result + (this.host == null ? "" : "//" + this.host);
            result = result + (this.port == -1 ? "" : ":" + this.port);
            result = result + "/" + this.app;
            return result;
        }

        public boolean equals(Object object) {
            if (!(object instanceof URI)) {
                return false;
            }
            URI other = (URI)object;
            if (this.proto == null || other.proto == null ? this.proto != null || other.proto != null : !this.proto.equals(other.proto)) {
                return false;
            }
            return this.equalsIgnoreProto(other);
        }

        public boolean equalsIgnoreProto(URI other) {
            if (this.host == null || other.host == null ? this.host != null || other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return !(this.app == null || other.app == null ? this.app != null || other.app != null : !this.app.equals(other.app));
        }
    }
}

