/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.util.FCSJProperties;
import com.macromedia.fcs.util.FCSJPropsException;
import java.util.AbstractQueue;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool {
    int _minThreads = 1;
    int _maxThreads = 5;
    int _maxIdleTime = 5000;
    int _maxIOQueueSize = 4000;
    int _maxWorkerQueueSize = 50;
    int _maxPingQueueSize = 10;
    String _name = null;
    private static Logger _log = null;
    static WeakHashMap<String, ThreadPool> _pools = new WeakHashMap();
    private ThreadPoolExecutor _pool;

    public static ThreadPool get() {
        return ThreadPool.get(null);
    }

    public static ThreadPool get(String name) {
        ThreadPool pool = _pools.get(name);
        if (pool == null) {
            return ThreadPool.createPool(name);
        }
        return pool;
    }

    private static final synchronized ThreadPool createPool(String name) {
        ThreadPool pool = _pools.get(name);
        if (pool == null) {
            pool = new ThreadPool(name);
            _pools.put(name, pool);
        }
        return pool;
    }

    public ThreadPool() {
        this.setFromConfig();
    }

    public ThreadPool(String name) {
        this._name = name;
        this.setFromConfig();
    }

    public synchronized void shutdown() {
        this._minThreads = 0;
        this._maxIdleTime = 0;
        this.notifyAll();
    }

    public void setFromConfig() {
        if (_log == null) {
            _log = LoggerFactory.getLogger(NetConnection.class);
        }
        FCSJProperties props = FCSJProperties.getConfigProps();
        try {
            if (props != null && !"FCSj_Ping".equals(this._name)) {
                this._minThreads = this.getIntFromConfig(props, FCSJProperties.PROP_MIN_THREADS, 1);
                this._maxThreads = this.getIntFromConfig(props, FCSJProperties.PROP_MAX_THREADS, 5);
                this._maxIdleTime = this.getIntFromConfig(props, FCSJProperties.PROP_MAX_IDLE, 5000);
                this._maxIOQueueSize = props.getIntValue(FCSJProperties.PROP_MAX_IO_QUEUE_SIZE, 4000);
                this._maxWorkerQueueSize = props.getIntValue(FCSJProperties.PROP_MAX_WORKER_QUEUE_SIZE, 50);
                _log.info("Loading ThreadPool (" + this._name + ") config; minThreads: " + this._minThreads + " maxThreads: " + this._maxThreads + " maxIdleTime: " + this._maxIdleTime + " maxIOQueueSize: " + this._maxIOQueueSize + " maxWorkerQueueSize: " + this._maxWorkerQueueSize);
            }
        }
        catch (FCSJPropsException e) {
            e.printStackTrace();
        }
        AbstractQueue queue = null;
        if (this._maxThreads == this._minThreads) {
            queue = new LinkedBlockingQueue<Runnable>();
        } else if ("FCSj_IO".equals(this._name)) {
            _log.info("Setting io threadpool queue size to: " + this._maxIOQueueSize);
            queue = new ArrayBlockingQueue(this._maxIOQueueSize);
        } else if ("FCSj_SSL_IO".equals(this._name)) {
            _log.info("Setting ssl io threadpool queue size to: " + this._maxIOQueueSize);
            queue = new ArrayBlockingQueue(this._maxIOQueueSize);
        } else if ("FCSj_Worker".equals(this._name)) {
            _log.info("Setting worker threadpool queue size to: " + this._maxWorkerQueueSize);
            queue = new ArrayBlockingQueue(this._maxWorkerQueueSize);
        } else if ("FCSj_Ping".equals(this._name)) {
            _log.info("Setting ping threadpool queue size to: " + this._maxPingQueueSize);
            queue = new ArrayBlockingQueue(this._maxPingQueueSize);
        }
        this._pool = new ThreadPoolExecutor(this._minThreads, this._maxThreads, (long)this._maxIdleTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), new FCSjThreadFactory(this._name));
    }

    private final int getIntFromConfig(FCSJProperties props, String prefix, int default_value) throws FCSJPropsException {
        try {
            return props.getIntValue(prefix + "." + this._name);
        }
        catch (Exception e) {
            return props.getIntValue(prefix + ".default", default_value);
        }
    }

    public synchronized void halt() {
        this._pool.shutdown();
        this.shutdown();
    }

    public ThreadPool(int minThreads, int maxThreads, int maxIdleTime) {
        this._minThreads = minThreads < 0 ? 0 : minThreads;
        this._maxThreads = maxThreads < this._minThreads ? 2 * this._minThreads : maxThreads;
        this._maxIdleTime = maxIdleTime < 0 ? 100 : maxIdleTime;
    }

    public synchronized void addTask(Runnable job) {
        if (_log.isDebugEnabled()) {
            _log.info(this._name + " Adding Task;  Current pending: " + this.getStats().pending + " poolSize: " + this.getStats().threads + " remainCapacity: " + this._pool.getQueue().remainingCapacity());
        }
        this._pool.execute(job);
    }

    public synchronized Stats getStats() {
        Stats stats = new Stats();
        stats.pending = this._pool.getQueue().size();
        stats.threads = this._pool.getPoolSize();
        return stats;
    }

    public static void shutdownAll() {
        for (ThreadPool pool : _pools.values()) {
            try {
                pool.halt();
            }
            catch (Exception e) {
                if (null == _log) continue;
                _log.error("ThreadPool shutdown", (Throwable)e);
            }
        }
    }

    private class FCSjThreadFactory
    implements ThreadFactory {
        private String name;
        private int count;

        public FCSjThreadFactory(String name) {
            this.name = name;
            this.count = 0;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(this.name + ":" + ++this.count);
            return thread;
        }
    }

    public static class Stats {
        public int pending = 0;
        public int threads = 0;
    }
}

