/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.BaseSocketChannel;
import com.macromedia.fcs.util.Transport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSocketChannel
extends BaseSocketChannel {
    private Transport _transport = null;
    private static Logger _log = null;

    public SimpleSocketChannel(Transport t, InetSocketAddress address) throws IOException {
        this._transport = t;
        try {
            if (_log == null) {
                _log = LoggerFactory.getLogger(SimpleSocketChannel.class);
            }
            if (this._sc == null) {
                this._sc = SocketChannel.open();
                this._sc.configureBlocking(false);
            }
            if (this._sc != null) {
                _log.info("successfully open socketchannel");
                this._sc.connect(address);
            } else {
                _log.error("failed to open socketchannel");
            }
        }
        catch (IOException e) {
            _log.error("IOException", (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        if (this._sc != null && remote != null) {
            return this._sc.connect(remote);
        }
        _log.error("failed to connect to " + remote);
        return false;
    }

    @Override
    public void initialization() throws IOException {
        _log.info("SocketChannel connection successful");
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this._sc != null ? this._sc.read(dst) : -1;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this._sc != null ? this._sc.write(src) : -1;
    }

    @Override
    public void close() throws IOException {
        if (this._sc != null) {
            this._sc.close();
        }
    }
}

