/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.BaseSocketChannel;
import com.macromedia.fcs.util.FCSJProperties;
import com.macromedia.fcs.util.SSLSocketChannel;
import com.macromedia.fcs.util.SocketChannelManager;
import com.macromedia.fcs.util.Transport;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketChannelManager
implements SocketChannelManager {
    private static SSLSocketChannelManager _sslscm = null;
    private SSLContext _sslContext = null;
    private Logger _log = null;
    private static String _ksType = null;
    private static String _ssProtocol = null;
    private static String _tmAlgorithm = null;
    private static String _ssProvider = null;
    private static String _ksPath = null;
    private static String _ksPassword = null;

    public SSLSocketChannelManager() {
        if (this._log == null) {
            this._log = LoggerFactory.getLogger(SSLSocketChannelManager.class);
        }
        try {
            this.setFromConfig();
            this._sslContext = this.initSSLContext();
        }
        catch (Exception e) {
            this._log.error("initialization error", (Throwable)e);
        }
    }

    public static SSLSocketChannelManager getInstance() {
        if (_sslscm == null) {
            _sslscm = new SSLSocketChannelManager();
        }
        return _sslscm;
    }

    @Override
    public BaseSocketChannel createChannel(Transport t, InetSocketAddress address) throws Exception {
        if (this._sslContext == null) {
            return null;
        }
        SSLEngine engine = this._sslContext.createSSLEngine();
        engine.setUseClientMode(true);
        return new SSLSocketChannel(engine, t, address);
    }

    private SSLContext initSSLContext() throws Exception {
        SSLContext sslContext;
        this._log.info("initSSLContext...");
        char[] passphrase = null;
        if (_ksPassword != null && _ksPassword.length() > 0) {
            passphrase = _ksPassword.toCharArray();
        }
        if (_ssProtocol == null || _ssProtocol.length() == 0) {
            this.setFromConfig();
        }
        SSLContext sSLContext = sslContext = _ssProvider == null || _ssProvider.length() <= 0 ? SSLContext.getInstance(_ssProtocol) : SSLContext.getInstance(_ssProtocol, _ssProvider);
        if (_ksPath != null && _ksPath.length() > 0) {
            KeyStore ks = null;
            try {
                ks = _ssProvider == null || _ssProvider.length() <= 0 ? KeyStore.getInstance(_ksType) : KeyStore.getInstance(_ksType, _ssProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ks.load(new FileInputStream(_ksPath), passphrase);
            if (this._log.isDebugEnabled()) {
                Enumeration<String> e = ks.aliases();
                while (e.hasMoreElements()) {
                    String al = e.nextElement().toString();
                    this._log.debug("CERTIFICATE: " + al);
                    this._log.debug(ks.getCertificate(al).toString());
                }
            }
            TrustManagerFactory tmf = _ssProvider == null || _ssProvider.length() <= 0 ? TrustManagerFactory.getInstance(_tmAlgorithm) : TrustManagerFactory.getInstance(_tmAlgorithm, _ssProvider);
            tmf.init(ks);
            sslContext.init(null, tmf.getTrustManagers(), null);
        } else {
            this._log.info("There is no trusted keystore present, switch to trust all server certs.");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
        }
        return sslContext;
    }

    private void setFromConfig() {
        FCSJProperties props = FCSJProperties.getConfigProps();
        try {
            if (props != null) {
                _ksType = props.getStringValue(FCSJProperties.PROP_KEYSTORE_TYPE, "JKS");
                _ssProtocol = props.getStringValue(FCSJProperties.PROP_SSL_PROTOCOL, "TLS");
                _tmAlgorithm = props.getStringValue(FCSJProperties.PROP_TM_ALGORITHM, "SunX509");
                _ssProvider = props.getStringValue(FCSJProperties.PROP_SSL_PROVIDER, "");
                _ksPath = props.getStringValue(FCSJProperties.PROP_KEYSTORE_PATH, "");
                _ksPassword = props.getStringValue(FCSJProperties.PROP_KEYSTORE_PASSWORD, "password");
            } else {
                _ksType = "JKS";
                _ssProtocol = "TLS";
                _tmAlgorithm = "SunX509";
                _ssProvider = "";
                _ksPath = "";
                _ksPassword = "password";
            }
        }
        catch (Exception e) {
            this._log.error("configuration error", (Throwable)e);
        }
    }
}

