/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.BaseSocketChannel;
import com.macromedia.fcs.util.Transport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketChannel
extends BaseSocketChannel {
    private Logger _log = null;
    private final SSLSession _session;
    private final SSLEngine _engine;
    private final ByteBuffer _inboundDecAppBuffer;
    private final ByteBuffer _inboundEncNetBuffer;
    private final ByteBuffer _outboundNetBuffer;
    private boolean appWantsToRead = false;
    private boolean appWantsToWrite = false;
    private boolean channelWantsToRead = false;
    private boolean channelWantsToWrite = false;
    private boolean handShakeInProgress = false;
    private SSLEngineResult.HandshakeStatus hsStatus;
    private ByteBuffer hsBuffer;
    private boolean _terminate = false;
    private boolean _close = false;
    private SSLEngineResult.Status status = null;
    private Transport _transport = null;
    private IOException aException = null;

    public SSLSocketChannel(SSLEngine engine, Transport t, InetSocketAddress address) throws IOException {
        this._engine = engine;
        this._transport = t;
        if (this._log == null) {
            this._log = LoggerFactory.getLogger(SSLSocketChannel.class);
        }
        if (this._sc == null) {
            this._sc = SocketChannel.open();
            this._sc.configureBlocking(false);
            this._sc.connect(address);
        }
        this._session = this._engine.getSession();
        this._inboundEncNetBuffer = ByteBuffer.allocate(this._session.getPacketBufferSize());
        this._inboundDecAppBuffer = ByteBuffer.allocate(this._session.getApplicationBufferSize());
        this._outboundNetBuffer = ByteBuffer.allocate(this._session.getPacketBufferSize());
    }

    @Override
    public void initialization() throws IOException {
        this._log.info("SocketChannel connection successful");
        if (this._log.isDebugEnabled()) {
            this._log.debug("_inboundEncNetBuffer: " + this._inboundEncNetBuffer.capacity() + ", _inboundDecAppBuffer: " + this._inboundDecAppBuffer.capacity() + ", _outboundNetBuffer: " + this._outboundNetBuffer.capacity());
        }
        this._inboundDecAppBuffer.position(this._inboundDecAppBuffer.limit());
        this._outboundNetBuffer.position(this._outboundNetBuffer.limit());
        this._transport.addInterestOps(0);
        this._log.debug("Starting handshake");
        this._engine.beginHandshake();
        this.hsStatus = this._engine.getHandshakeStatus();
        this.handShakeInProgress = true;
        this.hsBuffer = ByteBuffer.allocate(0);
        this.processHandShake();
    }

    @Override
    public int read(ByteBuffer destination) throws IOException {
        if (!this.validateChannel()) {
            return 0;
        }
        if (this.handShakeInProgress) {
            return 0;
        }
        if (this._engine.isInboundDone()) {
            return -1;
        }
        if (!this._inboundDecAppBuffer.hasRemaining()) {
            this._log.debug("don't have decrypted data waiting in the buffers returning" + this._inboundDecAppBuffer);
            return 0;
        }
        int amountToCopy = Math.min(this._inboundDecAppBuffer.remaining(), destination.remaining());
        this._log.debug("****_inboundDecAppBuffer.remaining(): " + this._inboundDecAppBuffer.remaining());
        this._log.debug("****destination.remaining(): " + destination.remaining());
        this._log.debug("****amountToCopy: " + amountToCopy);
        for (int i = 0; i < amountToCopy; ++i) {
            destination.put(this._inboundDecAppBuffer.get());
        }
        return amountToCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        SSLEngineResult res;
        if (!this.validateChannel()) {
            return 0;
        }
        if (this.handShakeInProgress) {
            this._log.debug("no writing during handshake");
            return 0;
        }
        if (this._outboundNetBuffer.hasRemaining()) {
            this._log.debug("there is more data waiting in _outboundNetBuffer, wait for selector to invoke write.");
            return 0;
        }
        this._outboundNetBuffer.clear();
        SSLSocketChannel sSLSocketChannel = this;
        synchronized (sSLSocketChannel) {
            this._log.debug("begin encrypting data for socketchannel");
            res = this._engine.wrap(src, this._outboundNetBuffer);
            this._log.debug("Wrapping: " + res);
            this._outboundNetBuffer.flip();
            this.flush();
        }
        return res.bytesProduced();
    }

    public void processReading() throws IOException {
        this.channelWantsToRead = false;
        this._log.debug("ProcessReading");
        try {
            if (this.handShakeInProgress) {
                this.processHandShake();
            } else if (this._terminate || this._transport.isClosing()) {
                this.doShutdown();
            } else {
                int bytesUnwrapped = this.readAndDecryptData();
                if (bytesUnwrapped == -1) {
                    if (this._engine.isInboundDone()) {
                        this._log.debug("End of stream but engine inbound is not closed");
                        return;
                    }
                    this._transport.readBuffer();
                } else if (bytesUnwrapped == 0) {
                    this.addInterestForRead();
                } else {
                    this._transport.readBuffer();
                }
            }
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
    }

    public void processWriting() throws IOException {
        this.channelWantsToWrite = false;
        this._log.debug("processWriting");
        try {
            if (this.flush()) {
                if (this.handShakeInProgress) {
                    this.processHandShake();
                } else if (this._terminate || this._transport.isClosing()) {
                    this.doShutdown();
                } else if (this.appWantsToWrite) {
                    this._transport.writeBuffer();
                }
            }
        }
        catch (IOException e) {
            this.handleException(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this._log.info("Shutting down SSL Channel");
        if (this._terminate) {
            this._log.info("Shutdown already in progress");
            return;
        }
        this._terminate = true;
        this._close = true;
        this.aException = null;
        this._engine.closeOutbound();
        if (this._outboundNetBuffer.hasRemaining()) {
            assert (this.channelWantsToWrite) : "Data to be sent but no write interest.";
            this._log.info("There is some data left to be sent. Waiting: " + this._outboundNetBuffer);
            return;
        }
        this.doShutdown();
    }

    public void flagForReading() throws IOException {
        if (!this.validateChannel()) {
            return;
        }
        this.appWantsToRead = true;
        if (this.handShakeInProgress) {
            return;
        }
        if (this._inboundDecAppBuffer.hasRemaining()) {
            this._transport.readBuffer();
        } else if (this._inboundEncNetBuffer.position() == 0 || this.status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            this.addInterestForRead();
        } else if (this.readAndDecryptData() == 0) {
            this.addInterestForRead();
        } else {
            this._transport.readBuffer();
        }
    }

    public void flagForWriting() throws IOException {
        if (!this.validateChannel()) {
            return;
        }
        if (!this.appWantsToWrite) {
            this._log.debug("Activating write interest");
            this.appWantsToWrite = true;
            if (this.handShakeInProgress) {
                return;
            }
            if (this._outboundNetBuffer.hasRemaining()) {
                this.addInterestForWrite();
            } else {
                this._transport.writeBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAndDecryptData() throws IOException {
        SSLSocketChannel sSLSocketChannel;
        SSLEngineResult res;
        if (this._inboundDecAppBuffer.hasRemaining()) {
            this._log.debug("_inboundEncNetBuffer.hasRemaining true ---- return : " + this._inboundEncNetBuffer.hasRemaining());
            return this._inboundDecAppBuffer.remaining();
        }
        assert (!this._inboundDecAppBuffer.hasRemaining()) : "Application buffer not empty";
        this._log.debug("_inboundDecAppBuffer.hasRemaining before read: " + this._inboundDecAppBuffer.hasRemaining());
        int bytesRead = this._sc.read(this._inboundEncNetBuffer);
        this._log.debug("Read from socket: " + bytesRead + " _inboundEncNetBuffer.hasRemaining: " + this._inboundEncNetBuffer.hasRemaining());
        if (bytesRead == -1) {
            this._engine.closeInbound();
            if (this._inboundEncNetBuffer.position() == 0 || this.status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                return -1;
            }
        }
        this._inboundDecAppBuffer.clear();
        this._inboundEncNetBuffer.flip();
        do {
            sSLSocketChannel = this;
            synchronized (sSLSocketChannel) {
                res = this._engine.unwrap(this._inboundEncNetBuffer, this._inboundDecAppBuffer);
            }
            this._log.info("Unwrapping:\n" + res);
        } while (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0);
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.completeHandShake();
        }
        if (this._inboundDecAppBuffer.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this._inboundEncNetBuffer.hasRemaining()) {
            sSLSocketChannel = this;
            synchronized (sSLSocketChannel) {
                res = this._engine.unwrap(this._inboundEncNetBuffer, this._inboundDecAppBuffer);
            }
            this._log.info("Unwrapping:\n" + res);
        }
        this.status = res.getStatus();
        this.hsStatus = res.getHandshakeStatus();
        assert (this.status != SSLEngineResult.Status.BUFFER_OVERFLOW) : "Buffer should not overflow: " + res.toString();
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this._log.info("Connection is being closed by peer.");
            this._terminate = true;
            this.doShutdown();
            return -1;
        }
        this._inboundEncNetBuffer.compact();
        this._inboundDecAppBuffer.flip();
        if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || this.hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this._log.debug("Rehandshaking...");
            this.processHandShake();
        }
        return this._inboundDecAppBuffer.remaining();
    }

    private boolean validateChannel() throws IOException {
        if (this._transport.isClosing()) {
            this.doShutdown();
            return false;
        }
        if (this._close) {
            throw new ClosedChannelException();
        }
        if (this.aException != null) {
            IOException ioe = new IOException("Asynchronous failure: " + this.aException.getMessage());
            ioe.initCause(this.aException);
            throw ioe;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown() throws IOException {
        this._log.debug("***********doShutdown*************");
        assert (!this._outboundNetBuffer.hasRemaining()) : "Buffer was not empty.";
        if (this.aException != null || this._engine.isOutboundDone()) {
            this._log.debug("Outbound is done. Closing socket");
            this._sc.close();
            return;
        }
        this._outboundNetBuffer.clear();
        SSLSocketChannel sSLSocketChannel = this;
        synchronized (sSLSocketChannel) {
            try {
                SSLEngineResult res = this._engine.wrap(this.hsBuffer, this._outboundNetBuffer);
                this._log.debug("Wrapping:\n" + res);
            }
            catch (SSLException e1) {
                this._log.warn("Error during shutdown.\n" + e1.toString());
                this._sc.close();
                return;
            }
            this._outboundNetBuffer.flip();
            this.flush();
            this._sc.close();
        }
    }

    private void completeHandShake() throws IOException {
        this.handShakeInProgress = false;
        assert (!this._outboundNetBuffer.hasRemaining()) : "There is data left to send after handshake!";
        this._transport.writeBuffer();
        this._transport.addInterestOps(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandShake() throws IOException {
        while (true) {
            this._log.debug(this.hsStatus.toString());
            switch (this.hsStatus) {
                case FINISHED: {
                    if (this.handShakeInProgress) {
                        this.completeHandShake();
                    }
                    return;
                }
                case NEED_TASK: {
                    this.processEngineHSWork();
                    break;
                }
                case NEED_UNWRAP: {
                    this.readAndDecryptData();
                    if (this.handShakeInProgress && this.status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        this.addInterestForRead();
                    }
                    return;
                }
                case NEED_WRAP: {
                    if (this._outboundNetBuffer.hasRemaining()) {
                        assert (this.channelWantsToWrite) : "Write interest should be active: " + this._outboundNetBuffer;
                        return;
                    }
                    this._outboundNetBuffer.clear();
                    SSLSocketChannel sSLSocketChannel = this;
                    synchronized (sSLSocketChannel) {
                        SSLEngineResult res = this._engine.wrap(this.hsBuffer, this._outboundNetBuffer);
                        this._log.info("Wrapping:\n" + res);
                        assert (res.bytesProduced() != 0) : "No net data produced during handshake wrap.";
                        assert (res.bytesConsumed() == 0) : "App data consumed during handshake wrap.";
                        this.hsStatus = res.getHandshakeStatus();
                        this._outboundNetBuffer.flip();
                        if (!this.flush()) {
                            return;
                        }
                        break;
                    }
                }
                case NOT_HANDSHAKING: {
                    return;
                }
            }
        }
    }

    private void processEngineHSWork() throws IOException {
        Runnable task;
        ExecutorService exec = Executors.newSingleThreadExecutor();
        while ((task = this._engine.getDelegatedTask()) != null) {
            exec.execute(task);
        }
        this.hsStatus = this._engine.getHandshakeStatus();
        this._log.debug("doEngineWork status: " + this.hsStatus.toString());
    }

    private boolean flush() throws IOException {
        if (!this._outboundNetBuffer.hasRemaining()) {
            this._log.debug("Trying to write but netData buffer is empty");
            return true;
        }
        int written = -1;
        try {
            if (this._sc.isOpen()) {
                written = this._sc.write(this._outboundNetBuffer);
            }
        }
        catch (IOException ioe) {
            this._log.debug("write failed, socket is dead");
            this._outboundNetBuffer.position(this._outboundNetBuffer.limit());
            throw ioe;
        }
        this._log.debug("Written to socket: " + written);
        if (this._outboundNetBuffer.hasRemaining()) {
            this._log.debug("The buffer is not empty. Register again with the selector");
            this.addInterestForWrite();
            return false;
        }
        return true;
    }

    private void addInterestForRead() throws IOException {
        if (this.channelWantsToRead) {
            return;
        }
        this.channelWantsToRead = true;
        this._transport.addInterestOps(1);
    }

    private void addInterestForWrite() throws IOException {
        if (this.channelWantsToWrite) {
            return;
        }
        this.channelWantsToWrite = true;
        this._transport.addInterestOps(4);
    }

    private void handleException(IOException e) {
        this._log.debug("************handleException*************", (Throwable)e);
        this.aException = e;
        this._engine.closeOutbound();
    }
}

