/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.Alarm;
import com.macromedia.fcs.util.AlarmEvent;
import com.macromedia.fcs.util.AlarmInterface;
import com.macromedia.fcs.util.AlarmWorkerThread;
import com.macromedia.fcs.util.Alarmable;
import com.macromedia.fcs.util.TimeSlot;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowResAlarm
implements Runnable,
AlarmInterface {
    static int MILIS_IN_RES_UNIT = 1000;
    private Thread _mgrThread;
    private static Logger _log;
    SortedMap<Long, TimeSlot> _timeSlotsMap;
    List<Set<Object>> _launchPad;
    boolean _killFlag = false;
    long _nextWakeUpTime;
    Object _workerThreadSynch = new Object();
    Object _idleSynch = new Object();
    AlarmWorkerThread[] _workerThreads;

    public LowResAlarm(int numWorkerThreads) {
        if (_log == null) {
            _log = LoggerFactory.getLogger(LowResAlarm.class);
        }
        this._timeSlotsMap = new TreeMap<Long, TimeSlot>();
        this._launchPad = new LinkedList<Set<Object>>();
        this._nextWakeUpTime = Long.MAX_VALUE;
        this._mgrThread = new Thread((Runnable)this, "AlarmMgr");
        this._mgrThread.setPriority(10);
        this._mgrThread.start();
        this._workerThreads = new AlarmWorkerThread[numWorkerThreads];
        for (int i = 0; i < numWorkerThreads; ++i) {
            this._workerThreads[i] = new AlarmWorkerThread(this, i);
        }
    }

    @Override
    public long getWaitTime(Calendar cal) {
        long msec = cal.getTimeInMillis() - System.currentTimeMillis();
        if (msec < 0L) {
            msec = 0L;
        }
        return msec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm createAlarm(Alarmable a, Calendar cal, Object o) {
        long msec = this.getWaitTime(cal);
        if (a == null) {
            throw new IllegalArgumentException("Alarmable is null");
        }
        if (msec < (long)MILIS_IN_RES_UNIT) {
            msec = MILIS_IN_RES_UNIT;
        }
        long ft = (System.currentTimeMillis() + msec) / (long)MILIS_IN_RES_UNIT;
        long rft = cal.getTimeInMillis() / (long)MILIS_IN_RES_UNIT;
        Long fireTime = new Long(ft *= (long)MILIS_IN_RES_UNIT);
        TimeSlot fireTimeSlot = this._getOrCreateTimeSlot(fireTime);
        AlarmEvent evt = this._getNewAlarmEvent(rft *= (long)MILIS_IN_RES_UNIT, fireTimeSlot, a, o);
        fireTimeSlot.addEvent(evt);
        if (this._nextWakeUpTime > ft) {
            Object object = this._idleSynch;
            synchronized (object) {
                this._idleSynch.notifyAll();
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm createAlarm(Alarmable a, long msec, Object o) {
        if (a == null) {
            throw new IllegalArgumentException("Alarmable is null");
        }
        if (msec < (long)MILIS_IN_RES_UNIT) {
            msec = MILIS_IN_RES_UNIT;
        }
        long ft = (System.currentTimeMillis() + msec) / (long)MILIS_IN_RES_UNIT;
        Long fireTime = new Long(ft *= (long)MILIS_IN_RES_UNIT);
        TimeSlot fireTimeSlot = this._getOrCreateTimeSlot(fireTime);
        AlarmEvent evt = this._getNewAlarmEvent(ft, fireTimeSlot, a, o);
        fireTimeSlot.addEvent(evt);
        if (this._nextWakeUpTime > ft) {
            Object object = this._idleSynch;
            synchronized (object) {
                this._idleSynch.notifyAll();
            }
        }
        return evt;
    }

    @Override
    public void removeAllAlarms(Alarmable a) {
    }

    @Override
    public void removeAlarm(Alarm o) {
        AlarmEvent evt = (AlarmEvent)o;
        if (evt._container != null) {
            evt._container.removeEvent(evt);
        }
    }

    @Override
    public void renewAlarm(Alarm o, Calendar cal) {
        this.renewAlarm(o, this.getWaitTime(cal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewAlarm(Alarm o, long msec) {
        TimeSlot fireTimeSlot;
        if (o == null) {
            throw new IllegalArgumentException("Alarm ID is null");
        }
        if (msec < (long)MILIS_IN_RES_UNIT) {
            msec = MILIS_IN_RES_UNIT;
        }
        AlarmEvent evt = (AlarmEvent)o;
        if (evt._container == null) {
            return;
        }
        if (this._getTimeSlot(new Long(evt._container._time)) == null) {
            return;
        }
        evt._container.removeEvent(evt);
        long ft = (System.currentTimeMillis() + msec) / (long)MILIS_IN_RES_UNIT;
        Long fireTime = new Long(ft *= (long)MILIS_IN_RES_UNIT);
        evt._container = fireTimeSlot = this._getOrCreateTimeSlot(fireTime);
        evt._time = ft;
        fireTimeSlot.addEvent(evt);
        if (this._nextWakeUpTime > ft) {
            Object object = this._idleSynch;
            synchronized (object) {
                this._idleSynch.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this._killFlag = true;
        Object object = this._idleSynch;
        synchronized (object) {
            this._idleSynch.notifyAll();
        }
        for (int i = 0; i < this._workerThreads.length; ++i) {
            this._workerThreads[i].kill();
        }
        Object object2 = this._workerThreadSynch;
        synchronized (object2) {
            this._workerThreadSynch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this._killFlag) {
            try {
                this._nextWakeUpTime = this._getNextWakeUpTime();
                long now = System.currentTimeMillis();
                long sleepTime = this._nextWakeUpTime - now;
                if (sleepTime > 0L) {
                    Object object = this._idleSynch;
                    synchronized (object) {
                        this._idleSynch.wait(sleepTime);
                        continue;
                    }
                }
                TimeSlot curTimeSlot = this._getNextTimeSlot();
                if (curTimeSlot == null) continue;
                this._fireTimeSlotEvents(curTimeSlot);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    AlarmEvent _getNewAlarmEvent(long alarmTime, TimeSlot fireTimeSlot, Alarmable a, Object passThru) {
        return new AlarmEvent(alarmTime, fireTimeSlot, a, passThru);
    }

    synchronized TimeSlot _getTimeSlot(Long time) {
        return (TimeSlot)this._timeSlotsMap.get(time);
    }

    synchronized TimeSlot _getOrCreateTimeSlot(Long time) {
        TimeSlot timeSlot = (TimeSlot)this._timeSlotsMap.get(time);
        if (null == timeSlot) {
            timeSlot = new TimeSlot(time);
            this._timeSlotsMap.put(time, timeSlot);
        }
        return timeSlot;
    }

    synchronized TimeSlot _getNextTimeSlot() {
        Long key = this._timeSlotsMap.firstKey();
        return (TimeSlot)this._timeSlotsMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _fireTimeSlotEvents(TimeSlot timeSlot) {
        Object object = this._launchPad;
        synchronized (object) {
            Set set = timeSlot._alarmEvents;
            synchronized (set) {
                this._launchPad.addAll(timeSlot._alarmEvents);
            }
        }
        object = this._workerThreadSynch;
        synchronized (object) {
            this._workerThreadSynch.notifyAll();
        }
    }

    synchronized long _getNextWakeUpTime() {
        Long key = null;
        try {
            key = this._timeSlotsMap.firstKey();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (key == null) {
            return Long.MAX_VALUE;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFiredAlarm(Object o, long msec) {
        if (o == null) {
            throw new IllegalArgumentException("Alarm is null");
        }
        if (msec < (long)MILIS_IN_RES_UNIT) {
            msec = MILIS_IN_RES_UNIT;
        }
        AlarmEvent evt = (AlarmEvent)o;
        long ft = (System.currentTimeMillis() + msec) / (long)MILIS_IN_RES_UNIT;
        Long fireTime = new Long(ft *= (long)MILIS_IN_RES_UNIT);
        TimeSlot fireTimeSlot = this._getOrCreateTimeSlot(fireTime);
        evt._time = ft;
        evt._container = fireTimeSlot;
        fireTimeSlot.addEvent(evt);
        if (this._nextWakeUpTime > ft) {
            Object object = this._idleSynch;
            synchronized (object) {
                this._idleSynch.notifyAll();
            }
        }
    }
}

