/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

public class FLV {
    protected DataInputStream _dis;
    protected byte _flvver;
    protected boolean _hasVideo;
    protected boolean _hasAudio;
    final int TYPE_AUDIO = 8;
    final int TYPE_VIDEO = 9;
    final int TYPE_DATA = 18;

    public FLV(File file) throws IOException {
        this.open(new FileInputStream(file));
    }

    public FLV(FileDescriptor fdObj) throws IOException {
        this.open(new FileInputStream(fdObj));
    }

    public FLV(String name) throws IOException {
        this.open(new FileInputStream(name));
    }

    protected void open(FileInputStream fis) throws IOException {
        this._dis = new DataInputStream(fis);
        if (this._dis.available() < 9) {
            throw new FormatException("Missing FLV Header");
        }
        byte[] hdr = new byte[5];
        this._dis.read(hdr);
        String shdr = new String(hdr, 0, 3, "UTF-8");
        if (!shdr.equals("FLV")) {
            throw new FormatException("Invalid FLV header " + shdr);
        }
        this._flvver = hdr[3];
        this._hasVideo = (hdr[4] & 1) != 0;
        boolean bl = this._hasAudio = (hdr[4] & 4) != 0;
        if ((hdr[4] & 0xFFFFFFFA) != 0) {
            throw new FormatException("Invalid FLV header");
        }
        int offset = this._dis.readInt() - 9;
        if (offset > 0) {
            this._dis.skipBytes(offset);
        } else if (offset < 0) {
            throw new FormatException("Invalid FLV header - negative offset");
        }
    }

    public byte getVersion() {
        return this._flvver;
    }

    public boolean hasAudio() {
        return this._hasAudio;
    }

    public boolean hasVideo() {
        return this._hasVideo;
    }

    public Tag read() throws IOException {
        try {
            this._dis.readInt();
            byte[] hdr = new byte[11];
            this._dis.read(hdr);
            Tag tag = new Tag();
            tag.type = hdr[0];
            int len = hdr[1] << 16 & 0xFF0000 | hdr[2] << 8 & 0xFF00 | hdr[3] & 0xFF;
            tag.time = hdr[7] << 24 & 0xFF000000 | hdr[4] << 16 & 0xFF0000 | hdr[5] << 8 & 0xFF00 | hdr[6] & 0xFF;
            tag.data = new byte[len];
            this._dis.read(tag.data);
            return tag;
        }
        catch (EOFException eofx) {
            return null;
        }
    }

    public void close() throws IOException {
        this._dis.close();
    }

    public class FormatException
    extends IOException {
        private static final long serialVersionUID = 500395688265033560L;

        public FormatException() {
        }

        public FormatException(String message) {
            super(message);
        }
    }

    public class Tag {
        public byte type;
        public long time;
        public byte[] data;
    }
}

