/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.FCSJPropsException;
import java.io.FileInputStream;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class FCSJProperties
extends Properties {
    private static final long serialVersionUID = -7950941543164624756L;
    private static FCSJProperties _configProp = null;
    private static boolean _pass = false;
    private static String CONFIG_FILE = "fcsj.properties";
    private static final String start = System.getProperty("file.separator").equals("/") ? "file:" : "file:/";
    private static final String MSG_ILLEGAL_CONFIG = "Can't find properties file: ";
    private static final String MSG_ILLEGAL_LONG_VALUE = "Illegal long value: ";
    private static final String MSG_ILLEGAL_INTEGER_VALUE = "Illegal integer value: ";
    private static final String MSG_ILLEGAL_BOOLEAN_VALUE = "Illegal boolean value: ";
    private static final String MSG_PROP_NOT_FOUND = "Property key not found: ";
    public static String PROP_MIN_THREADS = "fcsj.threadpool.minthreads";
    public static String PROP_MAX_THREADS = "fcsj.threadpool.maxthreads";
    public static String PROP_MAX_IDLE = "fcsj.threadpool.maxidletime";
    public static String PROP_MAX_IO_QUEUE_SIZE = "fcsj.threadpool.maxioqueuesize";
    public static String PROP_MAX_WORKER_QUEUE_SIZE = "fcsj.threadpool.maxworkerqueuesize";
    public static String PROP_KEYSTORE_TYPE = "fcsj.ssl.keystoretype";
    public static String PROP_KEYSTORE_PATH = "fcsj.ssl.keystorepath";
    public static String PROP_KEYSTORE_PASSWORD = "fcsj.ssl.keystorepassword";
    public static String PROP_SSL_PROTOCOL = "fcsj.ssl.protocol";
    public static String PROP_TM_ALGORITHM = "fcsj.ssl.algorithm";
    public static String PROP_SSL_PROVIDER = "fcsj.ssl.provider";

    public FCSJProperties(Properties props) {
        super(props);
    }

    public String getStringValue(String key) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new FCSJPropsException("Property value not found for key \"" + key + "\"");
        }
        return value;
    }

    public String getStringValue(String key, String defaultValue) {
        try {
            return this.getStringValue(key);
        }
        catch (FCSJPropsException fCSJPropsException) {
            return defaultValue;
        }
    }

    public boolean getBooleanValue(String key) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new FCSJPropsException(MSG_PROP_NOT_FOUND + key);
        }
        return this._checkBooleanValue(key, value);
    }

    public boolean getBooleanValue(String key, boolean defaultValue) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return this._checkBooleanValue(key, value);
    }

    public int getIntValue(String key) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new FCSJPropsException(MSG_PROP_NOT_FOUND + key);
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FCSJPropsException(MSG_ILLEGAL_INTEGER_VALUE + value);
        }
        return intValue;
    }

    public int getIntValue(String key, int defaultValue) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new FCSJPropsException(MSG_ILLEGAL_INTEGER_VALUE + value);
        }
        return intValue;
    }

    public long getLongValue(String key) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            throw new FCSJPropsException(MSG_PROP_NOT_FOUND + key);
        }
        long longValue = -1L;
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new FCSJPropsException(MSG_ILLEGAL_LONG_VALUE + value);
        }
        return longValue;
    }

    public long getLongValue(String key, long defaultValue) throws FCSJPropsException {
        String value = super.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        long longValue = -1L;
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new FCSJPropsException(MSG_ILLEGAL_LONG_VALUE + value);
        }
        return longValue;
    }

    public void setStringValue(String key, String value) {
        this.put(key, value);
    }

    public void setBooleanValue(String key, boolean value) {
        this.put(key, value ? "true" : "false");
    }

    public void setIntValue(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void setLongValue(String key, long value) {
        this.put(key, Long.toString(value));
    }

    public synchronized Set<Object> keySet(String keyStartsWith) {
        Set<Object> keys = super.keySet();
        LinkedHashSet<Object> foundKeys = new LinkedHashSet<Object>();
        if (keyStartsWith == null || keyStartsWith.length() == 0) {
            return foundKeys;
        }
        for (Object key : keys) {
            String keyName = key.toString();
            if (!keyName.startsWith(keyStartsWith)) continue;
            foundKeys.add(key);
        }
        return foundKeys;
    }

    public synchronized FCSJProperties getAll(String keyStartsWith) {
        FCSJProperties returnTable = new FCSJProperties();
        Set<Object> keys = this.keySet(keyStartsWith);
        if (keys.isEmpty()) {
            return returnTable;
        }
        for (Object key : keys) {
            Object value = super.get(key);
            if (value == null) continue;
            returnTable.put(key, value);
        }
        return returnTable;
    }

    private boolean _checkBooleanValue(String key, String value) throws FCSJPropsException {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return false;
        }
        throw new FCSJPropsException(MSG_ILLEGAL_BOOLEAN_VALUE + value);
    }

    public static synchronized FCSJProperties getConfigProps() {
        if (_configProp != null) {
            return _configProp;
        }
        if (_pass) {
            return _configProp;
        }
        _pass = true;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            loader = null;
        }
        if (loader == null) {
            try {
                loader = FCSJProperties.class.getClassLoader();
            }
            catch (Exception e) {
                loader = null;
            }
        }
        if (loader == null) {
            System.out.println("can't find class loader");
            return _configProp;
        }
        URL url = FCSJProperties.getPropResource(loader, CONFIG_FILE);
        String cfn = null;
        FileInputStream is = null;
        if (url == null) {
            System.out.println("can't find " + CONFIG_FILE + " in java.class.path looking for default");
            cfn = FCSJProperties.getDefaultPath(loader);
            if (cfn == null) {
                System.out.println("can't get resource");
                return _configProp;
            }
            try {
                is = new FileInputStream(cfn);
            }
            catch (Exception e) {
                System.out.println(MSG_ILLEGAL_CONFIG + cfn + " using default values");
                return _configProp;
            }
        }
        cfn = FCSJProperties.cleanPath(url.getFile());
        try {
            is = new FileInputStream(cfn);
        }
        catch (Exception e) {
            cfn = FCSJProperties.getDefaultPath(loader);
            if (cfn == null) {
                System.out.println("can't get resource");
                return _configProp;
            }
            try {
                is = new FileInputStream(cfn);
            }
            catch (Exception ne) {
                System.out.println(MSG_ILLEGAL_CONFIG + cfn + " using default values");
                return _configProp;
            }
        }
        System.out.println("Found config " + cfn);
        _configProp = new FCSJProperties();
        try {
            _configProp.load(is);
        }
        catch (Exception e) {
            _configProp = null;
            System.out.println(MSG_ILLEGAL_CONFIG + cfn + " using default values");
            return _configProp;
        }
        return _configProp;
    }

    public static URL getPropResource(ClassLoader loader, String resource) {
        URL url = null;
        try {
            url = loader.getResource(resource);
        }
        catch (Exception ne) {
            url = null;
        }
        if (url == null) {
            try {
                url = ClassLoader.getSystemResource(resource);
            }
            catch (Exception ne) {
                url = null;
            }
        }
        return url;
    }

    public static String getDefaultPath(ClassLoader loader) {
        String name = FCSJProperties.class.getName().replace('.', '/') + ".class";
        URL url = FCSJProperties.getPropResource(loader, name);
        if (url == null) {
            return null;
        }
        String cfn = url.getFile().replaceAll(name, "");
        cfn = cfn.replaceAll(".jar!/", "");
        int index = (cfn = cfn.replaceAll("%20", " ")).lastIndexOf("/");
        if ((cfn = index > 0 ? cfn.substring(0, index + 1) + CONFIG_FILE : cfn + CONFIG_FILE).startsWith(start)) {
            cfn = cfn.substring(start.length());
        }
        return cfn;
    }

    public static String cleanPath(String path) {
        int index = (path = path.replaceAll("%20", " ")).indexOf(".jar!/");
        if (index < 0) {
            return path;
        }
        if ((index = (path = path.substring(0, index)).lastIndexOf("/")) >= 0) {
            path = path.substring(0, index + 1);
        }
        if ((path = path + CONFIG_FILE).startsWith(start)) {
            path = path.substring(start.length());
        }
        return path;
    }

    public FCSJProperties() {
    }

    public static interface FILTERS {
        public static final int None = 0;
        public static final int NetConnection = 1;
        public static final int SharedObject = 2;
        public static final int MessageDispatcher = 4;
        public static final int RtmpTransport = 8;
        public static final int TCCommand = 16;
        public static final int ThreadPool = 32;
        public static final int ChunkOutputStream = 64;
    }
}

