/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.Transport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connector
extends Thread {
    static WeakReference<Connector> _defaultConnectorRef = new WeakReference<Object>(null);
    volatile boolean _shutdown = false;
    Selector _selector = null;
    LinkedList<Transport> _pending = new LinkedList();
    List<Transport> _removals = Collections.synchronizedList(new LinkedList());
    List<Transport> _interestOps = Collections.synchronizedList(new LinkedList());
    static final int MIN_DELAY = 32;
    static final int MAX_DELAY = 256;
    static int _outstanding = 0;
    long _logtime = 0L;
    private static Logger _log = null;

    public static synchronized Connector getDefault() {
        try {
            Connector connector = (Connector)_defaultConnectorRef.get();
            if (connector == null) {
                connector = new Connector();
                _defaultConnectorRef = new WeakReference<Connector>(connector);
                connector.setName("FCSj Connector");
                connector.setDaemon(true);
                connector.start();
            }
            return connector;
        }
        catch (IOException iox) {
            iox.printStackTrace();
            return null;
        }
    }

    public Connector() throws IOException {
        if (_log == null) {
            _log = LoggerFactory.getLogger(Connector.class);
        }
        this._selector = Selector.open();
    }

    public void shutdown() {
        this._shutdown = true;
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Transport t) {
        LinkedList<Transport> linkedList = this._pending;
        synchronized (linkedList) {
            this._pending.add(t);
        }
        this._selector.wakeup();
    }

    public void remove(Transport t) {
        this._removals.add(t);
        this._selector.wakeup();
    }

    public void setInterestOps(Transport t) {
        this._interestOps.add(t);
        this._selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processPending() {
        boolean processed = false;
        LinkedList<Transport> linkedList = this._pending;
        synchronized (linkedList) {
            while (!this._pending.isEmpty()) {
                Transport t = this._pending.removeFirst();
                t.register(this._selector);
                processed = true;
            }
        }
        return processed;
    }

    boolean processRemovals() {
        boolean processed = false;
        while (!this._removals.isEmpty()) {
            Transport t = this._removals.remove(0);
            t.unregister(this._selector);
            processed = true;
        }
        return processed;
    }

    boolean processInterestOps() {
        boolean processed = false;
        while (!this._interestOps.isEmpty()) {
            Transport t = this._interestOps.remove(0);
            t.onInterestOps();
            processed = true;
        }
        return processed;
    }

    boolean processSelected() {
        boolean processed = false;
        Iterator<SelectionKey> i = this._selector.selectedKeys().iterator();
        while (i.hasNext()) {
            try {
                SelectionKey sk = i.next();
                i.remove();
                Transport t = (Transport)sk.attachment();
                t.onSelection(sk);
                processed = true;
            }
            catch (Exception x) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream pw = new PrintStream(baos);
                x.printStackTrace(pw);
                _log.error(baos.toString());
            }
        }
        return processed;
    }

    static synchronized void incrOutstanding() {
        ++_outstanding;
    }

    static synchronized void decrOutstanding() {
        ++_outstanding;
    }

    static synchronized int getOutstanding() {
        return _outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int delay = 32;
        boolean processed = true;
        while (!this._shutdown) {
            if (this.processRemovals()) {
                processed = true;
            }
            if (processed) {
                delay = 32;
            } else {
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
                delay = delay < 256 ? 2 * delay : 256;
            }
            try {
                this._selector.select(1000L);
            }
            catch (Exception x) {
                this._shutdown = true;
                x.printStackTrace();
                break;
            }
            processed = false;
            if (this.processSelected()) {
                processed = true;
            }
            if (this.processInterestOps()) {
                processed = true;
            }
            if (!this.processPending()) continue;
            processed = true;
        }
        Class<Connector> x = Connector.class;
        synchronized (Connector.class) {
            _defaultConnectorRef.clear();
            // ** MonitorExit[x] (shouldn't be in output)
            for (SelectionKey sk : this._selector.keys()) {
                Transport t = (Transport)sk.attachment();
                t.unregister(this._selector);
                t.abort();
            }
            try {
                this._selector.close();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
            return;
        }
    }
}

