/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.util;

import com.macromedia.fcs.util.AlarmEvent;
import com.macromedia.fcs.util.LowResAlarm;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AlarmWorkerThread
implements Runnable {
    private Thread _thread;
    private int _threadNum;
    private LowResAlarm _alarmScheduler;
    private boolean killFlag;
    private static Logger _log;

    AlarmWorkerThread(LowResAlarm alarmScheduler, int threadNum) {
        this._thread = new Thread((Runnable)this, "AlarmWorker-" + threadNum);
        this._threadNum = threadNum;
        this._alarmScheduler = alarmScheduler;
        this.killFlag = false;
        if (_log == null) {
            _log = LoggerFactory.getLogger(AlarmWorkerThread.class);
        }
        this._thread.start();
    }

    void kill() {
        this.killFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (_log.isDebugEnabled()) {
            _log.debug("Alarm worker thread " + this._threadNum + " started.");
        }
        while (true) {
            if (this.killFlag) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Alarm worker thread " + this._threadNum + " exiting.");
                }
                this._thread = null;
                this._alarmScheduler = null;
                return;
            }
            AlarmEvent evt = null;
            evt = this._getEvent();
            if (evt == null) {
                Object object = this._alarmScheduler._workerThreadSynch;
                synchronized (object) {
                    try {
                        this._alarmScheduler._workerThreadSynch.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Alarm worker thread " + this._threadNum + " handling alarm event " + evt.toString());
            }
            long nextTime = -1L;
            try {
                nextTime = evt._alarmable.alarm(evt, evt._container._time, evt._passthru);
            }
            catch (ThreadDeath td) {
                _log.warn("AlarmWorkerThread caught ThreadDeath", (Throwable)td);
                throw td;
            }
            catch (Exception e) {
                _log.warn("AlarmWorkerThread: Alarmable has not caught this exception", (Throwable)e);
            }
            if (nextTime <= 0L) continue;
            this._alarmScheduler.resetFiredAlarm(evt, nextTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlarmEvent _getEvent() {
        List<Set<Object>> list = this._alarmScheduler._launchPad;
        synchronized (list) {
            if (!this._alarmScheduler._launchPad.isEmpty()) {
                return (AlarmEvent)((Object)this._alarmScheduler._launchPad.remove(0));
            }
            return null;
        }
    }
}

