/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.test;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.client.SharedObject;
import com.macromedia.fcs.common.Message;
import com.macromedia.fcs.common.OnMessageHandler;
import com.macromedia.fcs.common.OnRemoteCallHandler;
import com.macromedia.fcs.common.OnStatusHandler;
import com.macromedia.fcs.common.OnSyncHandler;
import com.macromedia.fcs.common.StatusInfo;
import com.macromedia.fcs.common.SyncInfo;
import com.macromedia.fcs.shared.TCCommand;
import com.macromedia.fcs.shared.TCJavaSerializer;
import com.macromedia.fcs.shared.TCMessage;
import java.util.List;

public class SharedObjectTest
implements OnStatusHandler,
OnRemoteCallHandler,
OnMessageHandler,
OnSyncHandler {
    @Override
    public void onStatus(StatusInfo sinfo) {
        System.out.println(sinfo);
    }

    @Override
    public Object onResolve(String methodName, Object[] args) throws NoSuchMethodException {
        System.out.println("onResolve: " + methodName);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i] + " (" + args[i].getClass() + ")");
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean onMessage(Message message) {
        return false;
    }

    @Override
    public void onUnhandledMessage(Message message) {
        switch (message.getType()) {
            case 8: {
                System.out.println("Audio Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                break;
            }
            case 9: {
                System.out.println("Video Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                break;
            }
            case 18: {
                Object arg;
                System.out.println("Data Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                TCJavaSerializer serializer = new TCJavaSerializer(message.getData(), message.getData().length, 0);
                while ((arg = serializer.GetVar(false)) != TCJavaSerializer.END_MARKER) {
                    System.out.println("\t" + arg);
                }
                break;
            }
            case 20: {
                System.out.println("Command Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                TCCommand cmdObj = new TCCommand((TCMessage)message, 0);
                System.out.println("\tmethod = " + cmdObj.getMethodName());
                System.out.println("\ttrxid = " + cmdObj.getTrxID());
                System.out.println("\tcmdData = " + cmdObj.getCmdData());
                System.out.println("\tnumArgs = " + cmdObj.getNumArgs());
                System.out.println("\targ0 = " + cmdObj.getArg(0));
            }
        }
    }

    @Override
    public void onSync(List<Object> list) {
        System.out.println("onSync: " + list.size());
        for (SyncInfo syncInfo : list) {
            System.out.println("\t" + syncInfo);
        }
    }

    public void test() {
        NetConnection nc = new NetConnection();
        nc.registerSink(this);
        nc.connect("rtmp://localhost/fcsjtest", "SharedObjecTest");
        SharedObject so = SharedObject.getRemote("foo", nc.getURI(), SharedObject.ON_SERVER_ONLY);
        so.registerSink(this);
        so.connect(nc);
        try {
            Thread.sleep(3000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        so.setProperty("prop1", "ABCDEFG");
        so.setProperty("prop2", "UVWXYZ");
        System.out.println("prop1 -> " + so.getProperty("prop1"));
        System.out.println("prop2 -> " + so.getProperty("prop2"));
        try {
            Thread.sleep(600000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        so.close();
        System.out.println("Closed " + so);
        nc.close();
    }

    public static void main(String[] args) throws Exception {
        new SharedObjectTest().test();
    }
}

