/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.test;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.client.NetStream;
import com.macromedia.fcs.common.Message;
import com.macromedia.fcs.common.OnMessageHandler;
import com.macromedia.fcs.common.OnRemoteCallHandler;
import com.macromedia.fcs.common.OnResultHandler;
import com.macromedia.fcs.common.OnStatusHandler;
import com.macromedia.fcs.common.StatusInfo;
import com.macromedia.fcs.shared.TCCommand;
import com.macromedia.fcs.shared.TCJavaSerializer;
import com.macromedia.fcs.shared.TCMessage;

public class CallTest
implements OnStatusHandler,
OnRemoteCallHandler,
OnMessageHandler {
    @Override
    public void onStatus(StatusInfo sinfo) {
        System.out.println(sinfo);
    }

    public Object method0(String str) {
        System.out.println("method0");
        System.out.println("\tstr = " + str);
        return null;
    }

    public Object method1(String str, Object[] strs) {
        System.out.println("method1");
        System.out.println("\tstr = " + str);
        System.out.println("\tstrs = ");
        for (int i = 0; i < strs.length; ++i) {
            System.out.println("\t\t" + strs[i]);
        }
        return null;
    }

    public void method2(Object arg0, Object arg1) {
        System.out.println("method2( " + arg0 + ", " + arg1 + " )");
    }

    @Override
    public Object onResolve(String methodName, Object[] args) throws NoSuchMethodException {
        System.out.println("onResolve: " + methodName);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i] + " (" + args[i].getClass() + ")");
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean onMessage(Message message) {
        return false;
    }

    @Override
    public void onUnhandledMessage(Message message) {
        switch (message.getType()) {
            case 8: {
                System.out.println("Audio Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                break;
            }
            case 9: {
                System.out.println("Video Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                break;
            }
            case 18: {
                Object arg;
                System.out.println("Data Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                TCJavaSerializer serializer = new TCJavaSerializer(message.getData(), message.getData().length, 0);
                while ((arg = serializer.GetVar(false)) != TCJavaSerializer.END_MARKER) {
                    System.out.println("\t" + arg);
                }
                break;
            }
            case 20: {
                System.out.println("Command Message: time - " + message.getTime() + ", " + message.getData().length + " bytes.");
                TCCommand cmdObj = new TCCommand((TCMessage)message, 0);
                System.out.println("\tmethod = " + cmdObj.getMethodName());
                System.out.println("\ttrxid = " + cmdObj.getTrxID());
                System.out.println("\tcmdData = " + cmdObj.getCmdData());
                System.out.println("\tnumArgs = " + cmdObj.getNumArgs());
                System.out.println("\targ0 = " + cmdObj.getArg(0));
            }
        }
    }

    public void test() {
        NetConnection nc = new NetConnection();
        nc.registerSink(this);
        nc.connect("rtmp://localhost/fcsjtest", "CallTest");
        nc.call("method0", (OnResultHandler)new ResultHandler("method0"), "Hello World!");
        NetStream ns = new NetStream(nc);
        ns.registerSink(this);
        ns.receive(9, false);
        ns.play("clip0");
        NetStream ns1 = new NetStream(nc);
        ns1.registerSink(this);
        ns1.publish("live1", "live");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        ns1.send("foo", new Object[]{"bar", "baz"});
        try {
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        ns1.send("foo", new Object[]{"bar1", "baz1"});
        try {
            Thread.sleep(1000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        ns1.send("foo", new Object[]{"bar2", "baz2"});
        try {
            Thread.sleep(600000L);
        }
        catch (Exception x) {
            // empty catch block
        }
        nc.close();
    }

    public static void main(String[] args) throws Exception {
        new CallTest().test();
    }

    public class ResultHandler
    implements OnResultHandler {
        String _methodName;

        public ResultHandler(String methodName) {
            this._methodName = methodName;
        }

        @Override
        public void onStatus(StatusInfo sinfo) {
            System.out.println(sinfo);
        }

        @Override
        public void onResult(Object result) {
            System.out.println(this._methodName + " returned " + result);
        }
    }
}

