/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.ChunkCommon;
import com.macromedia.fcs.shared.TCMessage;
import com.macromedia.fcs.shared.TGetMsgProc;
import java.util.Arrays;

public class TChunkContext
extends ChunkCommon {
    TChunkContext fpNext = null;
    TGetMsgProc fGetMsg = null;
    Object fGetMsgContext = null;
    int fQueueID = 0;
    int fPriority = 1;
    int fCount = 0;
    boolean fbEmpty = false;
    boolean fbUnregister = false;
    boolean fbWasEmptyOnRequest = false;
    TCMessage fpMsg = null;
    int fOutStreamId = 0;
    long fOutMsgTime = 0L;
    int fMsgInset = 0;
    int fChunkStreamId = 0;
    long fMsgTime = 0L;
    byte[] fHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    byte[] fExtendedTimestamp = new byte[]{0, 0, 0, 0};

    public void Release() {
    }

    public void SetCallbacks(TGetMsgProc getMsg, Object context) {
        this.fGetMsg = getMsg;
        this.fGetMsgContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCMessage GetNextMessage() {
        int[] fOutStreamIdReturn = new int[]{this.fOutStreamId};
        long[] fOutMsgTimeReturn = new long[]{this.fOutMsgTime};
        TCMessage result = this.fGetMsg.getMessage(this.fGetMsgContext, this.fQueueID, fOutStreamIdReturn, fOutMsgTimeReturn);
        this.fOutStreamId = fOutStreamIdReturn[0];
        this.fOutMsgTime = fOutMsgTimeReturn[0];
        if (result == null) {
            TChunkContext tChunkContext = this;
            synchronized (tChunkContext) {
                this.fbWasEmptyOnRequest = true;
            }
        }
        return result;
    }

    public float ScheduleStatus(int priorityTotal) {
        return (float)this.fCount / ((float)this.fPriority / (float)priorityTotal);
    }

    public synchronized void ResetEmptyOnRequest() {
        this.fbWasEmptyOnRequest = false;
    }

    public synchronized boolean WasEmptyOnRequest() {
        return this.fbWasEmptyOnRequest;
    }

    public boolean HasExtendedTimestamp() {
        int basicTimeStamp = TChunkContext.Get3ByteInt(this.fHeader, 0);
        return basicTimeStamp == 0xFFFFFF;
    }

    int GetHeaderSize(int controlType) {
        int size = 0;
        switch (controlType) {
            case 0: {
                size = 11;
                break;
            }
            case 64: {
                size = 7;
                break;
            }
            case 128: {
                size = 3;
            }
        }
        return size;
    }

    int GetMsgDelta() {
        int delta = TChunkContext.Get3ByteInt(this.fHeader, 0);
        if (delta == 0xFFFFFF) {
            delta = this.fExtendedTimestamp[0] << 24 & 0xFF000000 | this.fExtendedTimestamp[1] << 16 & 0xFF0000 | this.fExtendedTimestamp[2] << 8 & 0xFF00 | this.fExtendedTimestamp[3] << 0 & 0xFF;
        }
        return delta;
    }

    int GetMsgLen() {
        return TChunkContext.Get3ByteInt(this.fHeader, 3);
    }

    byte GetMsgTypeId() {
        return this.fHeader[6];
    }

    int GetMsgStreamId() {
        return this.fHeader[7] << 0 & 0xFF | this.fHeader[8] << 8 & 0xFF00 | this.fHeader[9] << 16 & 0xFF0000 | this.fHeader[10] << 24 & 0xFF000000;
    }

    void SetMsgDelta(int delta) {
        if (delta < 0xFFFFFF) {
            TChunkContext.Set3ByteInt(this.fHeader, 0, delta);
            Arrays.fill(this.fExtendedTimestamp, (byte)0);
        } else {
            TChunkContext.Set3ByteInt(this.fHeader, 0, 0xFFFFFF);
            this.fExtendedTimestamp[0] = (byte)(delta >> 24);
            this.fExtendedTimestamp[1] = (byte)(delta >> 16);
            this.fExtendedTimestamp[2] = (byte)(delta >> 8);
            this.fExtendedTimestamp[3] = (byte)delta;
        }
    }

    void SetMsgLen(int len) {
        TChunkContext.Set3ByteInt(this.fHeader, 3, len);
    }

    void SetMsgTypeId(byte typeId) {
        this.fHeader[6] = typeId;
    }

    void SetMsgStreamId(int streamId) {
        this.fHeader[7] = (byte)(streamId >> 0);
        this.fHeader[8] = (byte)(streamId >> 8);
        this.fHeader[9] = (byte)(streamId >> 16);
        this.fHeader[10] = (byte)(streamId >> 24);
    }
}

