/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.common.Message;
import com.macromedia.fcs.shared.ChunkCommon;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;

public class TCMessage
extends ChunkCommon
implements Message,
Cloneable {
    public static final int HDR_LENGTH = 11;
    public static final int BUF_ALLOC_LEN = 1024;
    private byte[] _header = new byte[11];
    private byte[] _data = new byte[0];

    public TCMessage() {
    }

    public TCMessage(int initialSize) {
        this._data = new byte[initialSize > 0 ? initialSize : 0];
    }

    public TCMessage(int msgID, long time, byte[] data) {
        this.setMsgID(msgID);
        this.setMsgTime(time);
        this.setMsgLen(data.length);
        this._data = data;
    }

    @Override
    public int getType() {
        return this.getMsgID();
    }

    @Override
    public double getTime() {
        return (double)this.getMsgTime() / 1000.0;
    }

    @Override
    public byte[] getData() {
        return this.getMsgBuffer();
    }

    @Override
    public void setType(int type) {
        this.setMsgID(type);
    }

    @Override
    public void setTime(double time) {
        this.setMsgTime((long)(time * 1000.0));
    }

    @Override
    public void setData(byte[] data) {
    }

    public byte getMsgID() {
        return this._header[0];
    }

    public int getMsgLen() {
        return TCMessage.getMsgLen(this._header);
    }

    public static int getMsgLen(byte[] header) {
        return header[1] << 16 & 0xFF0000 | header[2] << 8 & 0xFF00 | header[3] & 0xFF;
    }

    public long getMsgTime() {
        return TCMessage.getMsgTime(this._header);
    }

    public static long getMsgTime(byte[] header) {
        return header[7] << 24 & 0xFF000000 | header[4] << 16 & 0xFF0000 | header[5] << 8 & 0xFF00 | header[6] & 0xFF;
    }

    public int getStreamID() {
        return this._header[8] << 16 & 0xFF0000 | this._header[9] << 8 & 0xFF00 | this._header[10] & 0xFF;
    }

    public void setMsgID(int iMsg) {
        this._header[0] = (byte)iMsg;
    }

    public void setMsgLen(int uSize) {
        this._header[1] = (byte)(uSize >> 16);
        this._header[2] = (byte)(uSize >> 8);
        this._header[3] = (byte)uSize;
    }

    public void setMsgTime(long uTime) {
        this._header[7] = (byte)(uTime >> 24 & 0xFFL);
        this._header[4] = (byte)(uTime >> 16 & 0xFFL);
        this._header[5] = (byte)(uTime >> 8 & 0xFFL);
        this._header[6] = (byte)(uTime & 0xFFL);
    }

    public void setStreamID(int uStreamID) {
        this._header[8] = (byte)(uStreamID >> 16);
        this._header[9] = (byte)(uStreamID >> 8);
        this._header[10] = (byte)uStreamID;
    }

    public int getMsgSlot() {
        byte id = this.getMsgID();
        if (id == 9) {
            return 1;
        }
        if (id == 8) {
            return 0;
        }
        return 2;
    }

    public byte[] getMsgHdr() {
        return this._header;
    }

    public int getHdrLen() {
        return 11;
    }

    public byte[] getMsgBuffer() {
        return this._data;
    }

    public boolean setSize(int s) {
        if (this._data.length < s && !this.reallocBuffer(s)) {
            return false;
        }
        this.setMsgLen(s);
        return true;
    }

    public boolean write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    public boolean write(byte[] bytes, int length) {
        return this.write(bytes, 0, length);
    }

    public boolean write(byte[] bytes, int offset, int length) {
        if (!this.setSize(this.getMsgLen() + length)) {
            return false;
        }
        System.arraycopy(bytes, offset, this._data, this.getMsgLen() - length, length);
        return true;
    }

    public void writeString(String s) {
        try {
            this.write(s.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public void encodeString(String s) {
        try {
            String es = URLEncoder.encode(s, "UTF-8");
            this.writeString(es);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public void terminateString() {
        if (this._data.length > 0 && this._data[this._data.length - 1] != 0) {
            this.write(new byte[]{0});
        }
    }

    public boolean reallocBuffer(int uSize) {
        byte[] d;
        System.arraycopy(this._data, 0, d, 0, (d = new byte[uSize]).length < this._data.length ? d.length : this._data.length);
        this._data = d;
        return true;
    }

    public int getBufferSize() {
        return this._data != null ? this._data.length : 0;
    }

    public void clearHeader() {
        Arrays.fill(this._header, (byte)0);
    }

    public void copyHeader(byte[] header) {
        System.arraycopy(header, 0, this._header, 0, header.length);
    }
}

