/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.shared.TCDataParser;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.Amf3Input;
import flex.messaging.io.amf.Amf3Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TCJavaSerializer
extends TCDataParser {
    public static final Object END_MARKER = new Object();
    private boolean avmPlus = false;
    private Amf3Input avmPlusInput;
    private Amf3Output avmPlusOutput;
    private Map<Integer, Object> m_refTable = new HashMap<Integer, Object>();
    private Map<Object, Integer> m_refIndex = new HashMap<Object, Integer>();
    private Set<Object> m_lockTable = new HashSet<Object>();
    private boolean m_boolCheckECMA = false;
    private int m_serializeId = 0;

    public TCJavaSerializer(int objectEncoding) {
        this.setObjectEncoding(objectEncoding);
    }

    public TCJavaSerializer(boolean boolCheckEcma, int objectEncoding) {
        this.m_boolCheckECMA = boolCheckEcma;
        this.setObjectEncoding(objectEncoding);
    }

    public TCJavaSerializer(byte[] data, int dataLen, int objectEncoding) {
        super(data, dataLen);
        this.setObjectEncoding(objectEncoding);
    }

    public void setObjectEncoding(int objectEncoding) {
        this.avmPlus = objectEncoding == 3;
    }

    public void PutVar(String name, Object v, boolean clearTable) {
        this.AddToLockTable(v);
        this.ProcessScriptVar(new Object[]{v}, new String[]{name});
        if (clearTable) {
            this.CleanDirtyFlags();
        }
    }

    public void PutVar(Object v, boolean clearTable) {
        this.PutVar(null, v, clearTable);
    }

    public Object GetVar(boolean clearTable) {
        return this.GetVar(null, clearTable);
    }

    public Object GetVar(String[] strName, boolean clearTable) {
        assert (!this._isStoring);
        Object[] v = new Object[1];
        if (this.ProcessScriptVar(v, strName) == 9) {
            v[0] = END_MARKER;
        }
        if (clearTable) {
            this.CleanDirtyFlags();
        }
        return v[0];
    }

    public int skipVar() {
        if (this.GetPos() >= this.GetSize()) {
            return 9;
        }
        byte varType = this.GetByte();
        switch (varType) {
            case 0: {
                this.SetPos(this.GetPos() + 8);
                break;
            }
            case 1: 
            case 7: {
                this.SetPos(this.GetPos() + 1);
                break;
            }
            case 2: 
            case 4: {
                int iSize = this.GetWord();
                this.SetPos(this.GetPos() + iSize);
                break;
            }
            case 12: {
                int iSize = this.GetDWord();
                this.SetPos(this.GetPos() + iSize);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 13: {
                break;
            }
            case 11: {
                this.SetPos(this.GetPos() + 10);
                break;
            }
            case 16: {
                int iSize = this.GetWord();
                this.SetPos(this.GetPos() + iSize);
            }
            case 3: {
                int iSize;
                do {
                    iSize = this.GetWord();
                    this.SetPos(this.GetPos() + iSize);
                } while (this.skipVar() != 9);
                break;
            }
            case 8: {
                int length = this.GetDWord();
                do {
                    int iSize = this.GetWord();
                    this.SetPos(this.GetPos() + iSize);
                } while (this.skipVar() != 9);
                break;
            }
            case 10: {
                int length = this.GetDWord();
                for (int i = 0; i < length; ++i) {
                    this.skipVar();
                }
                break;
            }
        }
        return varType;
    }

    private void AddObjectToTable(Object object, int index) {
        Integer iIndex = new Integer(index);
        this.m_refTable.put(iIndex, object);
        this.m_refIndex.put(object, iIndex);
        this.AddToLockTable(object);
    }

    private void AddToLockTable(Object object) {
        this.m_lockTable.add(object);
    }

    private void CleanDirtyFlags() {
        this.m_refTable.clear();
        this.m_refIndex.clear();
        this.m_serializeId = 0;
    }

    private void ProcessName(String[] strName) {
        if (this._isStoring) {
            this.PutString(strName[0]);
        } else {
            strName[0] = this.GetString();
        }
    }

    private void ProcessNumberType(Object[] v) {
        if (this._isStoring) {
            this.PutDouble(((Number)v[0]).doubleValue());
        } else {
            v[0] = new Double(this.GetDouble());
        }
    }

    private void ProcessBooleanType(Object[] v) {
        if (this._isStoring) {
            this.PutByte((byte)((Boolean)v[0] != false ? 1 : 0));
        } else {
            v[0] = this.GetByte() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private void ProcessStringType(Object[] v, int type) {
        if (this._isStoring) {
            this.PutString((String)v[0], type);
        } else {
            v[0] = this.GetString();
            this.AddToLockTable(v[0]);
        }
    }

    private void ProcessDateType(Object[] v) {
        if (this._isStoring) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)v[0]);
            this.PutDouble(cal.getTime().getTime());
            this.PutWord(cal.get(15) + cal.get(16));
        } else {
            double dateValue = this.GetDouble();
            double offset = this.GetWord();
            v[0] = new Date((long)dateValue);
            this.AddToLockTable(v[0]);
        }
    }

    private void ProcessAvmPlusObjectType(Object[] v, int iType) {
        if (this.avmPlusOutput == null) {
            SerializationContext.getSerializationContext().legacyMap = true;
            this.avmPlusOutput = new Amf3Output(SerializationContext.getSerializationContext());
        }
        if (this._isStoring) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.avmPlusOutput.setOutputStream((OutputStream)outStream);
            try {
                this.avmPlusOutput.writeObject(v[0]);
                this.PutData(outStream.toByteArray(), outStream.size());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ByteArrayInputStream inStream = new ByteArrayInputStream(this.GetBuf(), this.GetPos(), this.GetSize() - this.GetPos());
            this.avmPlusInput.setInputStream((InputStream)inStream);
            try {
                v[0] = this.avmPlusInput.readObject();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void ProcessObjectType(Object[] v, int iType) {
        if (this._isStoring) {
            String clsname;
            this.AddObjectToTable(v[0], this.m_serializeId++);
            if (iType == 16 && (clsname = NetConnection.getRegisteredName(v[0].getClass())) != null) {
                this.PutString(clsname);
            }
            Field[] fields = v[0].getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    if (9 != this.ProcessScriptVar(new Object[]{fields[i].get(v[0])}, new String[]{fields[i].getName()})) continue;
                    break;
                }
                catch (IllegalAccessException iax) {
                    // empty catch block
                }
            }
            this.PutString("");
            this.PutByte((byte)9);
        } else {
            Object[] vv = new Object[1];
            String[] strName = new String[1];
            if (iType == 16) {
                String clsname = this.GetString();
                Class cls = NetConnection.getRegisteredClass(clsname);
                if (cls != null) {
                    try {
                        v[0] = cls.newInstance();
                        while (this.ProcessScriptVar(vv, strName) != 9) {
                            try {
                                cls.getField(strName[0]).set(v[0], vv[0]);
                            }
                            catch (NoSuchFieldException nsfx) {
                            }
                            catch (SecurityException sx) {}
                        }
                    }
                    catch (InstantiationException ix) {
                        iType = 3;
                    }
                    catch (IllegalAccessException iax) {
                        iType = 3;
                    }
                } else {
                    iType = 3;
                }
            }
            if (iType == 3) {
                v[0] = new HashMap();
                this.AddObjectToTable(v[0], this.m_serializeId++);
                while (this.ProcessScriptVar(vv, strName) != 9) {
                    ((Map)v[0]).put(strName[0], vv[0]);
                }
            }
        }
    }

    private void ProcessStrictArrayType(Object[] v) {
        if (this._isStoring) {
            this.AddObjectToTable(v[0], this.m_serializeId++);
            int iLen = Array.getLength(v[0]);
            this.PutDWord(iLen);
            Object[] vv = new Object[1];
            for (int i = 0; i < iLen; ++i) {
                vv[0] = Array.get(v[0], i);
                if (9 != this.ProcessScriptVar(vv, null)) {
                    continue;
                }
                break;
            }
        } else {
            int length = this.GetDWord();
            Class<Object> elemcls = null;
            Object[] vv = new Object[1];
            Object[] tmpArray = new Object[length];
            for (int i = 0; i < length && 9 != this.ProcessScriptVar(vv, null); ++i) {
                tmpArray[i] = vv[0];
                if (vv[0] != null && elemcls == null) {
                    elemcls = vv[0].getClass();
                    continue;
                }
                if (vv[0] == null || elemcls == vv[0].getClass()) continue;
                elemcls = Object.class;
            }
            if (elemcls == null || elemcls == Object.class) {
                v[0] = tmpArray;
            } else if (elemcls == Boolean.class) {
                boolean[] boolArray = (boolean[])Array.newInstance(Boolean.TYPE, length);
                for (int i = 0; i < length; ++i) {
                    boolArray[i] = (Boolean)tmpArray[i];
                }
                v[0] = boolArray;
            } else if (elemcls == Double.class) {
                double[] dblArray = (double[])Array.newInstance(Double.TYPE, length);
                for (int i = 0; i < length; ++i) {
                    dblArray[i] = (Double)tmpArray[i];
                }
                v[0] = dblArray;
            } else if (elemcls == String.class) {
                String[] strArray = (String[])Array.newInstance(String.class, length);
                for (int i = 0; i < length; ++i) {
                    strArray[i] = (String)tmpArray[i];
                }
                v[0] = strArray;
            } else if (elemcls == Date.class) {
                Date[] dateArray = (Date[])Array.newInstance(Date.class, length);
                for (int i = 0; i < length; ++i) {
                    dateArray[i] = (Date)tmpArray[i];
                }
            } else {
                v[0] = tmpArray;
            }
            this.AddObjectToTable(v[0], this.m_serializeId++);
        }
    }

    private void ProcessECMAArrayType(Object[] v) {
        if (this._isStoring) {
            Map map = (Map)v[0];
            this.AddObjectToTable(map, this.m_serializeId++);
            this.PutDWord(map.size());
            for (Map.Entry me : map.entrySet()) {
                String[] strName = new String[]{me.getKey().toString()};
                Object[] vv = new Object[]{me.getValue()};
                if (9 != this.ProcessScriptVar(vv, strName)) continue;
                break;
            }
            this.PutString("");
            this.PutByte((byte)9);
        } else {
            HashMap<String, Object> map;
            v[0] = map = new HashMap<String, Object>();
            this.AddObjectToTable(map, this.m_serializeId++);
            int length = this.GetDWord();
            String[] strName = new String[1];
            Object[] objValue = new Object[1];
            while (this.ProcessScriptVar(objValue, strName) != 9) {
                map.put(strName[0], objValue[0]);
            }
        }
    }

    private void ProcessNullType(Object[] v) {
        if (!this._isStoring) {
            v[0] = null;
        }
    }

    private void ProcessUndefinedType(Object[] v) {
        if (!this._isStoring) {
            v[0] = null;
        }
    }

    private void ProcessReferenceType(Object[] v) {
        if (this._isStoring) {
            assert (this.m_refIndex.containsKey(v[0]));
            this.PutWord(this.getRefId(v[0]));
        } else {
            int id = this.GetWord();
            v[0] = this.m_refTable.get(new Integer(id));
        }
    }

    private int ProcessScriptVar(Object[] v, String[] strName) {
        int varType = 9;
        if (this._isStoring) {
            varType = this._ProcessScriptVar(v, strName);
        } else {
            varType = this._ProcessScriptVar(v, strName);
            if (this._underFlow) {
                return 9;
            }
        }
        return varType;
    }

    private int _ProcessScriptVar(Object[] v, String[] strName) {
        int varType;
        if (this._isStoring) {
            if (v[0] == null) {
                varType = 5;
            } else if (v[0] instanceof String) {
                byte[] sbytes;
                String jStr = (String)v[0];
                try {
                    sbytes = jStr.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException uex) {
                    uex.printStackTrace();
                    assert (false);
                    sbytes = new byte[]{};
                }
                varType = sbytes.length > 65535 ? 12 : 2;
            } else if (v[0] instanceof Number) {
                varType = 0;
            } else if (v[0] instanceof Boolean) {
                varType = 1;
            } else if (this.isReference(v[0])) {
                varType = 7;
            } else if (v[0].getClass().isArray()) {
                varType = this.avmPlus ? 17 : 10;
            } else if (v[0] instanceof Date) {
                varType = 11;
            } else if (v[0] instanceof Map) {
                varType = this.avmPlus ? 17 : 8;
            } else if (v[0] instanceof Object) {
                if (this.avmPlus) {
                    varType = 17;
                } else {
                    varType = 3;
                    if (NetConnection.getRegisteredName(v[0].getClass()) != null) {
                        varType = 16;
                    }
                }
            } else {
                varType = 13;
            }
            if (strName != null && strName[0] != null) {
                this.ProcessName(strName);
            }
            this.PutByte((byte)varType);
        } else {
            if (strName != null) {
                this.ProcessName(strName);
            }
            varType = this.GetByte();
        }
        switch (varType) {
            case 0: {
                this.ProcessNumberType(v);
                break;
            }
            case 1: {
                this.ProcessBooleanType(v);
                break;
            }
            case 2: 
            case 12: {
                this.ProcessStringType(v, varType);
                break;
            }
            case 17: {
                this.ProcessAvmPlusObjectType(v, varType);
                break;
            }
            case 3: 
            case 16: {
                this.ProcessObjectType(v, varType);
                break;
            }
            case 10: {
                this.ProcessStrictArrayType(v);
                break;
            }
            case 8: {
                this.ProcessECMAArrayType(v);
                break;
            }
            case 4: {
                this.ProcessStringType(v, 2);
                break;
            }
            case 5: {
                this.ProcessNullType(v);
                break;
            }
            case 6: 
            case 13: {
                this.ProcessUndefinedType(v);
                break;
            }
            case 7: {
                this.ProcessReferenceType(v);
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                this.ProcessDateType(v);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return varType;
    }

    private boolean isReference(Object obj) {
        return this.m_refIndex.containsKey(obj);
    }

    private int getRefId(Object obj) {
        if (this.m_refIndex.containsKey(obj)) {
            return this.m_refIndex.get(obj);
        }
        return -1;
    }
}

