/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.ChunkCommon;
import java.io.UnsupportedEncodingException;

public class TCDataParser
extends ChunkCommon {
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    private byte[] _buf = null;
    private int _len = 0;
    private int _size = 0;
    private int _tagCode = 0;
    private int _tagPos = 0;
    private boolean _tagIsBig = false;
    protected boolean _underFlow = false;
    protected boolean _isStoring = false;

    public TCDataParser() {
        this.Init();
        this._isStoring = true;
    }

    public TCDataParser(byte[] data, int dataLen) {
        this.Init();
        this._buf = data;
        this._size = dataLen;
    }

    public void StartTag(int code, boolean isBig) {
        assert (this._tagCode == 0);
        assert (this._isStoring);
        this._tagCode = code;
        this._tagPos = this._len;
        this._tagIsBig = isBig;
        this.PutWord(0);
        if (isBig) {
            this.PutDWord(0);
        }
    }

    public void FinishTag() {
        assert (this._isStoring);
        int pos = this._len;
        int iTagLen = pos - this._tagPos - (this._tagIsBig ? 6 : 2);
        assert (iTagLen >= 0);
        this._len = this._tagPos;
        if (this._tagIsBig) {
            this.PutWord(this._tagCode << 6 | 0x3F);
            this.PutDWord(iTagLen);
        } else {
            assert (iTagLen < 63);
            this.PutWord(this._tagCode << 6 | iTagLen);
        }
        this._len = pos;
        this._tagCode = 0;
    }

    public int GetTag(int[] tagLen) {
        int iTagCode = this.GetWord() & 0xFFFF;
        if (this._underFlow) {
            return -1;
        }
        tagLen[0] = iTagCode & 0x3F;
        if (tagLen[0] == 63) {
            tagLen[0] = this.GetDWord();
        }
        return iTagCode >> 6;
    }

    public byte[] GetBuf() {
        return this._buf;
    }

    public int GetPos() {
        return this._len;
    }

    public int GetSize() {
        return this._size;
    }

    public void SetPos(int pos) {
        this._len = pos;
    }

    public void PutByte(byte b) {
        assert (this._isStoring);
        if (this.CheckBufferSize(1)) {
            this._buf[this._len++] = b;
        }
    }

    public byte GetByte() {
        assert (!this._isStoring);
        assert (this._len < this._size);
        if (this._len >= this._size) {
            this._underFlow = true;
            ++this._len;
            return 0;
        }
        return this._buf[this._len++];
    }

    public void PutDouble(double d) {
        assert (this._isStoring);
        if (this.CheckBufferSize(8)) {
            long bits = Double.doubleToRawLongBits(d);
            this.PutDWord((int)(bits >> 32));
            this.PutDWord((int)bits);
        }
    }

    public double GetDouble() {
        assert (!this._isStoring);
        assert (this._len + 8 <= this._size);
        if (this._len + 8 > this._size) {
            this._underFlow = true;
            this._len += 8;
            return 0.0;
        }
        long bits = 0L;
        bits |= (long)this.GetDWord() << 32;
        return Double.longBitsToDouble(bits |= (long)this.GetDWord() & 0xFFFFFFFFL);
    }

    public void PutWord(int d) {
        assert (this._isStoring);
        if (this.CheckBufferSize(2)) {
            this._buf[this._len++] = (byte)(0xFF & d >> 8);
            this._buf[this._len++] = (byte)(0xFF & d);
        }
    }

    public int GetWord() {
        assert (!this._isStoring);
        assert (this._len + 2 <= this._size);
        if (this._len + 2 > this._size) {
            this._underFlow = true;
            this._len += 2;
            return 0;
        }
        int result = this._buf[this._len++] << 8 & 0xFF00;
        return result |= this._buf[this._len++] & 0xFF;
    }

    public void PutDWord(int d) {
        assert (this._isStoring);
        if (this.CheckBufferSize(4)) {
            this._buf[this._len++] = (byte)(d >> 24);
            this._buf[this._len++] = (byte)(d >> 16);
            this._buf[this._len++] = (byte)(d >> 8);
            this._buf[this._len++] = (byte)d;
        }
    }

    public int GetDWord() {
        assert (!this._isStoring);
        assert (this._len + 4 <= this._size);
        if (this._len + 4 > this._size) {
            this._underFlow = true;
            this._len += 4;
            return 0;
        }
        int result = this._buf[this._len++] << 24 & 0xFF000000;
        result |= this._buf[this._len++] << 16 & 0xFF0000;
        result |= this._buf[this._len++] << 8 & 0xFF00;
        return result |= this._buf[this._len++] & 0xFF;
    }

    public void PutString(String string) {
        this.PutString(string, 2);
    }

    public void PutString(String string, int type) {
        block11: {
            try {
                assert (this._isStoring);
                byte[] sbytes = string.getBytes("UTF-8");
                int count = sbytes.length;
                assert (type != 2 || count <= 65535);
                if (type == 12) {
                    if (this.CheckBufferSize(count + 4)) {
                        this.PutDWord(count);
                        System.arraycopy(sbytes, 0, this._buf, this._len, count);
                        this._len += count;
                    }
                } else if (type == 2) {
                    if (this.CheckBufferSize(count + 2)) {
                        this.PutWord(count);
                        System.arraycopy(sbytes, 0, this._buf, this._len, count);
                        this._len += count;
                    }
                } else assert (false);
            }
            catch (UnsupportedEncodingException uex) {
                uex.printStackTrace();
                if ($assertionsDisabled) break block11;
                throw new AssertionError();
            }
        }
    }

    public String GetString() {
        return this.GetString(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetString(int type) {
        int count;
        assert (!this._isStoring);
        int n = count = type == 2 ? this.GetWord() : this.GetDWord();
        assert (this._len + count <= this._size);
        if (this._len + count > this._size) {
            this._underFlow = true;
            this._len += count;
            return "";
        }
        try {
            String string = new String(this._buf, this._len, count, "UTF-8");
            return string;
        }
        catch (UnsupportedEncodingException uex) {
            uex.printStackTrace();
            assert (false);
            String string = null;
            return string;
        }
        finally {
            this._len += count;
        }
    }

    public boolean SkipString() {
        return this.SkipString(2);
    }

    public boolean SkipString(int type) {
        int count;
        assert (!this._isStoring);
        int n = count = type == 2 ? this.GetWord() : this.GetDWord();
        assert (this._len + count <= this._size);
        if (this._len + count > this._size) {
            this._underFlow = true;
            this._len += count;
            return false;
        }
        this._len += count;
        return true;
    }

    public void PutData(byte[] data, int count) {
        assert (this._isStoring);
        if (this.CheckBufferSize(count)) {
            System.arraycopy(data, 0, this._buf, this._len, count);
            this._len += count;
        }
    }

    public byte[] GetData(int count) {
        assert (!this._isStoring);
        assert (this._len + count <= this._size);
        if (this._len + count > this._size) {
            this._underFlow = true;
            this._len += count;
            return null;
        }
        byte[] bytes = new byte[count];
        System.arraycopy(this._buf, this._len, bytes, 0, count);
        this._len += count;
        return bytes;
    }

    private boolean CheckBufferSize(int requestSize) {
        assert (this._isStoring);
        if ((requestSize += this._len) > this._size) {
            int newSize;
            int n = newSize = this._size > 65536 ? this._size + 65536 : this._size * 2;
            if (newSize < 256) {
                newSize = 256;
            }
            if (newSize < requestSize) {
                newSize = requestSize + 1024;
            }
            byte[] newBuf = new byte[newSize];
            if (this._buf != null) {
                System.arraycopy(this._buf, 0, newBuf, 0, this._len);
            }
            this._buf = newBuf;
            this._size = newSize;
            return true;
        }
        return true;
    }

    private void Init() {
    }
}

