/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.ChunkCommon;
import com.macromedia.fcs.shared.TCDataParser;
import com.macromedia.fcs.shared.TCMessage;

public class TCContainerMsg
extends ChunkCommon {
    private byte[] m_buffer;
    private int m_bufferLen;
    private int m_containerEnd = -1;
    private int m_firstEventPos = -1;
    private int m_currEventPos = -1;
    private String m_containerName;
    private long m_containerVersion = -1L;
    private int m_uFlags;
    private int m_uMagicNum;

    public TCContainerMsg(TCMessage pMsg) {
        this.m_buffer = pMsg.getMsgBuffer();
        this.m_bufferLen = pMsg.getMsgLen();
        if (this.m_bufferLen > 0) {
            TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
            this.m_containerEnd = parser.GetPos() + this.m_bufferLen;
            this.m_containerName = parser.GetString();
            this.m_containerVersion = (long)parser.GetDWord() & 0xFFFFFFFFL;
            this.m_uFlags = parser.GetDWord();
            this.m_uMagicNum = parser.GetDWord();
            this.m_currEventPos = this.m_firstEventPos = parser.GetPos();
        }
    }

    public String getContainerName() {
        return this.m_containerName;
    }

    public long getVersion() {
        return this.m_containerVersion;
    }

    public int getFlags() {
        return this.m_uFlags;
    }

    public int getMagicNum() {
        return this.m_uMagicNum;
    }

    public int getFirstEventType() {
        int result = 255;
        TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
        parser.SetPos(this.m_firstEventPos);
        result = parser.GetByte() & 0xFF;
        int size = parser.GetDWord();
        this.m_currEventPos = this.m_firstEventPos;
        return result;
    }

    public int getNextEventType() {
        int result = 255;
        TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
        if (this.m_currEventPos < this.m_containerEnd) {
            parser.SetPos(this.m_currEventPos);
            parser.GetByte();
            this.m_currEventPos = parser.GetDWord();
            this.m_currEventPos += parser.GetPos();
            parser.SetPos(this.m_currEventPos);
            if (this.m_currEventPos < this.m_containerEnd) {
                result = parser.GetByte();
            }
        }
        return result;
    }

    public int getNumSlots() {
        int result = 0;
        TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
        parser.SetPos(this.m_firstEventPos);
        while (parser.GetPos() < this.m_containerEnd) {
            int eventType = parser.GetPos();
            int eventSize = parser.GetDWord();
            ++result;
            parser.SetPos(parser.GetPos() + eventSize);
        }
        return result;
    }

    public String getSlotName(int iSlot) {
        TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
        int slotCount = 0;
        parser.SetPos(this.m_firstEventPos);
        if (iSlot < 0) {
            parser.SetPos(this.m_currEventPos);
            parser.GetByte();
            parser.GetDWord();
            return parser.GetString();
        }
        while (parser.GetPos() < this.m_containerEnd) {
            int eventType = parser.GetPos();
            int eventSize = parser.GetDWord();
            if (slotCount == iSlot) {
                return parser.GetString();
            }
            ++slotCount;
            parser.SetPos(parser.GetPos() + eventSize);
        }
        return null;
    }

    public byte[] getSlotBlob(int iSlot) {
        int[] range = this.getSlotBlobRange(iSlot);
        if (range != null) {
            byte[] blob = new byte[range[1]];
            System.arraycopy(this.m_buffer, range[1], blob, 0, blob.length);
            return blob;
        }
        return null;
    }

    public int getSlotBlobOffset(int iSlot) {
        int[] range = this.getSlotBlobRange(iSlot);
        if (range != null) {
            return range[0];
        }
        return -1;
    }

    public long getSlotBlobSize(int iSlot) {
        int[] range = this.getSlotBlobRange(iSlot);
        if (range != null) {
            return range[1];
        }
        return 0L;
    }

    public int[] getSlotBlobRange(int iSlot) {
        TCDataParser parser = new TCDataParser(this.m_buffer, this.m_bufferLen);
        int slotCount = 0;
        if (iSlot < 0) {
            parser.SetPos(this.m_currEventPos);
            byte eventType = parser.GetByte();
            int bufPos = parser.GetPos();
            int eventSize = parser.GetDWord();
            return new int[]{bufPos, eventSize + 4};
        }
        parser.SetPos(this.m_firstEventPos);
        while (parser.GetPos() < this.m_containerEnd) {
            byte eventType = parser.GetByte();
            int bufPos = parser.GetPos();
            int eventSize = parser.GetDWord();
            if (slotCount == iSlot) {
                return new int[]{bufPos, eventSize + 4};
            }
            ++slotCount;
            parser.SetPos(parser.GetPos() + eventSize);
        }
        return null;
    }

    public static void updateProxyMsg(TCMessage pMsg, int uFlag, int uMagic) {
        TCDataParser parser = new TCDataParser(pMsg.getMsgBuffer(), pMsg.getMsgLen());
        parser.SkipString();
        parser.GetDWord();
        TCContainerMsg.Set4ByteInt(parser.GetBuf(), parser.GetPos(), uFlag);
        parser.GetDWord();
        TCContainerMsg.Set4ByteInt(parser.GetBuf(), parser.GetPos(), uMagic);
    }

    public static void updateVersion(TCMessage pMsg, long uVersion) {
        TCDataParser parser = new TCDataParser(pMsg.getMsgBuffer(), pMsg.getMsgLen());
        parser.SkipString();
        TCContainerMsg.Set4ByteInt(parser.GetBuf(), parser.GetPos(), (int)uVersion);
    }
}

