/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.TCJavaSerializer;
import com.macromedia.fcs.shared.TCMessage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCCommand
extends TCJavaSerializer {
    public static final int cmdUnknown = 0;
    public static final int cmdCloseStream = 1;
    public static final int cmdConnectRequest = 2;
    public static final int cmdCreateStream = 3;
    public static final int cmdDeleteStream = 4;
    public static final int cmdOnStatus = 5;
    public static final int cmdPause = 6;
    public static final int cmdPlay = 7;
    public static final int cmdPublish = 8;
    public static final int cmdReceiveAudio = 9;
    public static final int cmdReceiveVideo = 10;
    public static final int cmdSeek = 11;
    static final Map<String, Integer> g_cmdMap = new HashMap<String, Integer>();
    private static Logger _log;
    private int m_iCmd;
    private Object m_cmd;
    private Object m_trxID;
    private Object m_cmdData;
    private Vector<Object> m_args = new Vector();

    public TCCommand(int objectEncoding) {
        super(objectEncoding);
        if (_log == null) {
            _log = LoggerFactory.getLogger(TCCommand.class);
        }
        this.m_iCmd = 0;
        this.setResponseSuccess();
    }

    public TCCommand(TCMessage pMsg, int objectEncoding) {
        super(pMsg.getMsgBuffer(), pMsg.getMsgLen(), objectEncoding);
        if (_log == null) {
            _log = LoggerFactory.getLogger(TCCommand.class);
        }
        this.m_iCmd = 0;
        if (this.GetPos() < pMsg.getMsgLen()) {
            this.m_cmd = this.GetVar(false);
            this.m_iCmd = this.mapCommand((String)this.m_cmd);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("GetPos() = " + this.GetPos() + ", msglen = " + pMsg.getMsgLen());
            _log.debug("m_cmd = " + this.m_cmd + ", m_iCmd = " + this.m_iCmd);
        }
        if (this.GetPos() < pMsg.getMsgLen()) {
            this.m_trxID = this.GetVar(false);
        }
        if (_log.isDebugEnabled()) {
            _log.debug("m_trxID = " + this.m_trxID);
        }
        if (this.GetPos() < pMsg.getMsgLen()) {
            this.m_cmdData = this.GetVar(false);
        }
        while (this.GetPos() < pMsg.getMsgLen()) {
            this.m_args.add(this.GetVar(false));
        }
    }

    public int getCmd() {
        return this.m_iCmd;
    }

    public String getMethodName() {
        return (String)this.m_cmd;
    }

    public Object getTrxID() {
        return this.m_trxID;
    }

    public Object getCmdData() {
        return this.m_cmdData;
    }

    public void setCmdData(Object cmd) {
        this.m_cmdData = cmd;
    }

    public Object getArg(int iArg) {
        try {
            return this.m_args.get(iArg);
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            assert (false);
            if (_log != null) {
                _log.error("ArrayIndexOutOfBoundsException");
            }
            return null;
        }
    }

    public int getNumArgs() {
        return this.m_args.size();
    }

    public void setResponseSuccess() {
        this.m_cmd = "_result";
    }

    public void setResponseFailure() {
        this.m_cmd = "_error";
    }

    public void setMethodName(String strCommand) {
        this.m_cmd = strCommand;
    }

    public void setTrxID(Object trxID) {
        this.m_trxID = trxID;
    }

    public void setResponseData(String strName, Object strValue) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.m_cmdData;
        if (map == null) {
            this.m_cmdData = map = new HashMap<String, Object>();
        }
        map.put(strName, strValue);
    }

    public void setUserArg(Object strValue) {
        this.m_args.add(strValue);
    }

    public void setInfoObj(String strClass, String strCode, String strMsg) {
        this.setInfoObj(strClass, strCode, strMsg, null);
    }

    public void setInfoObj(String strClass, String strCode, String strMsg, byte[] pstrDetails) {
        this.setInfoProperty("level", strClass);
        this.setInfoProperty("code", strCode);
        this.setInfoProperty("description", strMsg);
        this.setInfoProperty("details", pstrDetails);
    }

    public void setInfoProperty(String strName, Object val) {
        HashMap<String, Object> map;
        if (this.m_args.isEmpty()) {
            map = new HashMap<String, Object>();
            this.m_args.add(map);
        } else {
            map = (HashMap<String, Object>)this.m_args.get(0);
        }
        map.put(strName, val);
    }

    public TCMessage getCommandResponse() {
        TCMessage pMsg = new TCMessage();
        pMsg.setMsgID(20);
        pMsg.setStreamID(0);
        this.PutVar(this.m_cmd, false);
        this.PutVar(this.m_trxID, false);
        this.PutVar(this.m_cmdData, false);
        Iterator<Object> it = this.m_args.iterator();
        while (it.hasNext()) {
            this.PutVar(it.next(), false);
        }
        pMsg.write(this.GetBuf(), this.GetPos());
        return pMsg;
    }

    private int mapCommand(String pstrCmd) {
        Integer I = g_cmdMap.get(pstrCmd);
        return I == null ? 0 : I;
    }

    static {
        g_cmdMap.put("a", new Integer(0));
        g_cmdMap.put("closeStream", new Integer(1));
        g_cmdMap.put("connect", new Integer(2));
        g_cmdMap.put("createStream", new Integer(3));
        g_cmdMap.put("deleteStream", new Integer(4));
        g_cmdMap.put("onStatus", new Integer(5));
        g_cmdMap.put("pause", new Integer(6));
        g_cmdMap.put("play", new Integer(7));
        g_cmdMap.put("publish", new Integer(8));
        g_cmdMap.put("receiveAudio", new Integer(9));
        g_cmdMap.put("receiveVideo", new Integer(10));
        g_cmdMap.put("seek", new Integer(11));
        _log = null;
    }
}

