/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.ChunkCommon;
import com.macromedia.fcs.shared.TCMessage;
import com.macromedia.fcs.shared.TChunkContext;
import com.macromedia.fcs.shared.TChunkIOState;
import com.macromedia.fcs.shared.TChunkOutFlowCtl;
import com.macromedia.fcs.shared.TGetMsgProc;
import com.macromedia.fcs.shared.TMsgList;
import com.macromedia.fcs.shared.TWriteProc;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCChunkOutputStream
extends ChunkCommon
implements TGetMsgProc {
    private static Logger _log = null;
    TChunkContext fpContexts = null;
    TChunkContext fpActive = null;
    TWriteProc fWrite = null;
    Object fWriteContext = null;
    byte[] fScheduleHistory = new byte[100];
    int fScheduleIndex;
    int fPriorityTotal = 0;
    TChunkIOState fState = new TChunkIOState();
    TMsgList fpProtocolQueue = null;
    TMsgList fpUserCtlMsgQueue = null;
    boolean fbSentVersionByte = false;
    int fTimeBasis = 0;
    TChunkOutFlowCtl fAckState = new TChunkOutFlowCtl();

    public TCChunkOutputStream() {
        this.fState.fStage = 2;
        this.ClearSchedule();
        TChunkContext pProtocolMsgContext = new TChunkContext();
        pProtocolMsgContext.fChunkStreamId = 2;
        pProtocolMsgContext.SetCallbacks(this, this);
        this.Register(pProtocolMsgContext, 1000, 0);
        if (_log == null) {
            _log = LoggerFactory.getLogger(TCChunkOutputStream.class);
        }
    }

    public void Release() {
        this.HandleUnregistration();
        assert (this.fpContexts.fChunkStreamId == 2);
        assert (this.fpContexts.fpNext == null);
        this.fpContexts.Release();
        this.fpContexts = null;
        this.Reset();
    }

    @Override
    public synchronized TCMessage getMessage(Object context, int priority, int[] pStreamID, long[] pTimeStamp) {
        TMsgList kill;
        TCMessage result = null;
        if (this.fpProtocolQueue != null) {
            result = this.fpProtocolQueue.fpMsg;
            kill = this.fpProtocolQueue;
            this.fpProtocolQueue = this.fpProtocolQueue.fpNext;
            kill.Release();
            pStreamID[0] = result.getStreamID();
            pTimeStamp[0] = result.getMsgTime();
        }
        if (result == null && this.fpUserCtlMsgQueue != null) {
            result = this.fpUserCtlMsgQueue.fpMsg;
            kill = this.fpUserCtlMsgQueue;
            this.fpUserCtlMsgQueue = this.fpUserCtlMsgQueue.fpNext;
            kill.Release();
            pStreamID[0] = result.getStreamID();
            pTimeStamp[0] = result.getMsgTime();
        }
        return result;
    }

    public void SetTimeBasis(int timeBasis) {
        this.fTimeBasis = timeBasis;
    }

    public void SetCallbacks(TWriteProc write, Object context) {
        this.fWrite = write;
        this.fWriteContext = context;
    }

    public synchronized TCMessage WriteMessage(boolean[] pbDidWrite) {
        boolean writeret;
        pbDidWrite[0] = false;
        int[] pInset = new int[1];
        int[] pBytesNeeded = new int[1];
        if (this.fAckState.fbState != 3) {
            if (this.fAckState.fbState == 1) {
                pbDidWrite[0] = this.DoConnectAck(this.fAckState.fbVersion);
                this.fAckState.fbState = (short)2;
            } else if (this.fAckState.fbState == 2 && this.fAckState.fpPingBuffer != null) {
                pInset[0] = 1536 - this.fAckState.fuPingSize;
                pBytesNeeded[0] = this.fAckState.fuPingSize;
                boolean writeret2 = this.Write(this.fAckState.fpPingBuffer, pInset, pBytesNeeded, pbDidWrite);
                this.fAckState.fuPingSize = pBytesNeeded[0];
                if (writeret2) {
                    this.fAckState.fpPingBuffer = null;
                    this.fAckState.fbState = (short)3;
                }
            }
            return null;
        }
        if (this.fAckState.fboolEnableAck && !this.fAckState.fboolSendAck && this.fAckState.fuOutSeq > this.fAckState.fuWinLimit + (long)(this.fAckState.fuAckWindow * 10)) {
            return null;
        }
        TCMessage retval = null;
        if (this.fpActive == null) {
            boolean[] bNewMsg = new boolean[]{false};
            this.fpActive = this.SelectContext(bNewMsg);
            if (this.fpActive != null) {
                this.fState.fBytesNeeded = 0;
                this.fState.fInset = 0;
                int msgDelta = (int)(this.fpActive.fOutMsgTime - this.fpActive.fMsgTime);
                assert (this.fpActive.fChunkStreamId >= 2 && this.fpActive.fChunkStreamId < 65600);
                if (this.fpActive.fChunkStreamId < 64) {
                    this.fState.fControlData[0] = (byte)this.fpActive.fChunkStreamId;
                    this.fState.fBytesNeeded = 1;
                } else if (this.fpActive.fChunkStreamId < 320) {
                    this.fState.fControlData[0] = 0;
                    this.fState.fControlData[1] = (byte)(this.fpActive.fChunkStreamId - 64);
                    this.fState.fBytesNeeded = 2;
                } else {
                    this.fState.fControlData[0] = 1;
                    this.fState.fControlData[1] = (byte)((this.fpActive.fChunkStreamId - 64) % 256);
                    this.fState.fControlData[2] = (byte)((this.fpActive.fChunkStreamId - 64) / 256);
                    this.fState.fBytesNeeded = 3;
                }
                this.fState.fStage = 2;
                boolean bDone = false;
                if (bNewMsg[0]) {
                    boolean bNewMsgStreamId;
                    this.fpActive.fMsgInset = 0;
                    boolean bl = bNewMsgStreamId = this.fpActive.GetMsgStreamId() != this.fpActive.fOutStreamId;
                    assert (this.fpActive.fpMsg.getStreamID() != 0 || this.fpActive.fpMsg.getMsgID() != 8 && this.fpActive.fpMsg.getMsgID() != 9);
                    if (bNewMsgStreamId || this.fpActive.fMsgTime == 0L || msgDelta < 0) {
                        this.fState.fControlData[0] = (byte)(this.fState.fControlData[0] | 0);
                        this.fpActive.SetMsgTypeId(this.fpActive.fpMsg.getMsgID());
                        this.fpActive.SetMsgStreamId(this.fpActive.fOutStreamId);
                        this.fpActive.SetMsgLen(this.fpActive.fpMsg.getMsgLen());
                        this.fpActive.SetMsgDelta((int)this.fpActive.fOutMsgTime);
                        bDone = true;
                    } else if (this.fpActive.GetMsgLen() != this.fpActive.fpMsg.getMsgLen() || this.fpActive.GetMsgTypeId() != this.fpActive.fpMsg.getMsgID()) {
                        this.fState.fControlData[0] = (byte)(this.fState.fControlData[0] | 0x40);
                        this.fpActive.SetMsgTypeId(this.fpActive.fpMsg.getMsgID());
                        this.fpActive.SetMsgLen(this.fpActive.fpMsg.getMsgLen());
                        this.fpActive.SetMsgDelta(msgDelta);
                        bDone = true;
                    } else if (this.fpActive.GetMsgDelta() != msgDelta) {
                        this.fState.fControlData[0] = (byte)(this.fState.fControlData[0] | 0x80);
                        this.fpActive.SetMsgDelta(msgDelta);
                        bDone = true;
                    }
                }
                if (!bDone) {
                    this.fState.fControlData[0] = (byte)(this.fState.fControlData[0] | 0xC0);
                }
            }
        }
        if (this.fpActive != null && this.fState.fStage == 2) {
            pInset[0] = this.fState.fInset;
            pBytesNeeded[0] = this.fState.fBytesNeeded;
            writeret = this.Write(this.fState.fControlData, pInset, pBytesNeeded, pbDidWrite);
            this.fState.fBytesNeeded = pBytesNeeded[0];
            this.fState.fInset = pInset[0];
            if (writeret) {
                this.fState.fStage = 3;
                this.fState.fInset = 0;
                this.fState.fBytesNeeded = this.fpActive.GetHeaderSize(this.fState.fControlData[0] & 0xC0);
            }
        }
        if (this.fpActive != null && this.fState.fStage == 3) {
            pInset[0] = this.fState.fInset;
            pBytesNeeded[0] = this.fState.fBytesNeeded;
            writeret = this.Write(this.fpActive.fHeader, pInset, pBytesNeeded, pbDidWrite);
            this.fState.fBytesNeeded = pBytesNeeded[0];
            this.fState.fInset = pInset[0];
            if (writeret) {
                this.fState.fStage = 4;
                this.fState.fInset = 0;
                int n = this.fState.fBytesNeeded = this.fpActive.HasExtendedTimestamp() ? 4 : 0;
            }
        }
        if (this.fpActive != null && this.fState.fStage == 4) {
            pInset[0] = this.fState.fInset;
            pBytesNeeded[0] = this.fState.fBytesNeeded;
            writeret = this.Write(this.fpActive.fExtendedTimestamp, pInset, pBytesNeeded, pbDidWrite);
            this.fState.fBytesNeeded = pBytesNeeded[0];
            this.fState.fInset = pInset[0];
            if (writeret) {
                this.fState.fStage = 5;
                int messageBytesLeft = this.fpActive.GetMsgLen() - this.fpActive.fMsgInset;
                this.fState.fBytesNeeded = TCChunkOutputStream.CoreMin(this.fState.fMaxChunkSize, messageBytesLeft);
                this.fState.fInset = 0;
            }
        }
        if (this.fpActive != null && this.fState.fStage == 5) {
            pInset[0] = this.fState.fInset + this.fpActive.fMsgInset;
            pBytesNeeded[0] = this.fState.fBytesNeeded;
            writeret = this.Write(this.fpActive.fpMsg.getMsgBuffer(), pInset, pBytesNeeded, pbDidWrite);
            this.fState.fBytesNeeded = pBytesNeeded[0];
            this.fState.fInset = pInset[0] - this.fpActive.fMsgInset;
            if (writeret) {
                int newMaxChunkSize;
                this.fpActive.fMsgInset += this.fState.fInset;
                if (this.fpActive.fMsgInset == this.fpActive.GetMsgLen()) {
                    this.fpActive.fMsgTime = this.fpActive.fOutMsgTime;
                    if (this.fpActive.fChunkStreamId == 2) {
                        this.ApplyProtocolMsg(this.fpActive.fpMsg);
                    } else {
                        retval = this.fpActive.fpMsg;
                    }
                    this.fpActive.fpMsg = null;
                } else if (this.fpActive.fpMsg.getMsgSlot() == 0 && this.fState.fMaxChunkSize < (newMaxChunkSize = TCChunkOutputStream.CoreMin(this.fpActive.fpMsg.getMsgLen(), 1024))) {
                    this.SetMaxChunkSize(newMaxChunkSize);
                }
                this.fpActive = null;
            }
        }
        if (_log.isDebugEnabled() && retval != null) {
            _log.debug("Message " + retval.getTime() + " " + retval.getType() + " " + retval.getMsgLen() + " written");
        }
        return retval;
    }

    public synchronized void Reset() {
        this.fpActive = null;
        this.fpProtocolQueue = null;
        this.fpUserCtlMsgQueue = null;
        this.ClearSchedule();
    }

    public synchronized void Register(TChunkContext pChunkContext, int priority, int iQueueID) {
        pChunkContext.fQueueID = iQueueID;
        pChunkContext.fPriority = priority;
        if (pChunkContext.fChunkStreamId == 2) {
            assert (this.fpContexts == null || this.fpContexts.fChunkStreamId != 2);
            pChunkContext.fpNext = this.fpContexts;
            this.fpContexts = pChunkContext;
        } else {
            int chunkStreamId = 3;
            if (this.fpContexts == null) {
                this.fpContexts = pChunkContext;
            } else {
                TChunkContext i = this.fpContexts;
                TChunkContext pi = this.fpContexts;
                while (true) {
                    if (i == null || i.fChunkStreamId > chunkStreamId) {
                        pChunkContext.fChunkStreamId = chunkStreamId;
                        pChunkContext.fpNext = i;
                        pi.fpNext = pChunkContext;
                        break;
                    }
                    chunkStreamId = i.fChunkStreamId + 1;
                    pi = i;
                    i = i.fpNext;
                }
            }
        }
        this.ClearSchedule();
        this.fPriorityTotal += pChunkContext.fPriority;
    }

    public synchronized void Unregister(TChunkContext pChunkContext) {
        pChunkContext.fbUnregister = true;
    }

    public void SetMaxChunkSize(int maxChunkSize) {
        TCMessage pMsg = new TCMessage();
        pMsg.setMsgID(1);
        byte[] data = new byte[]{(byte)(maxChunkSize >> 24), (byte)(maxChunkSize >> 16), (byte)(maxChunkSize >> 8), (byte)maxChunkSize};
        pMsg.write(data);
        this.QueueProtocolMsg(pMsg);
    }

    public void SendUserCtrlMsg(byte[] pBytes, int iSize) {
        TCMessage pMsg = new TCMessage();
        pMsg.setMsgID(4);
        pMsg.write(pBytes, iSize);
        this.QueueUserCtlMsg(pMsg);
    }

    public boolean HandleFlowControlEvent(int iEvent, Object pArg1, Object pArg2) {
        switch (iEvent) {
            case 6: {
                return this.HandleConnectReq(((byte[])pArg1)[0]);
            }
            case 7: {
                return this.HandleConnectAck((byte[])pArg1, (Long)pArg2);
            }
            case 8: {
                return this.HandleConnectAckRecv((byte[])pArg1);
            }
            case 9: {
                byte[] msgBuffer = ((TCMessage)pArg1).getMsgBuffer();
                int uNewBW = TCChunkOutputStream.Get4ByteInt(msgBuffer, 0);
                short uType = msgBuffer[4];
                return this.SetBWLimit(uNewBW, 0L, uType);
            }
            case 10: {
                this.fAckState.fuDownStrmBW = (int)((Long)pArg1).longValue();
                return true;
            }
            case 1: {
                ((TCMessage)pArg1).setMsgID(3);
                this.QueueProtocolMsg((TCMessage)pArg1);
                this.fAckState.fboolSendAck = true;
                return true;
            }
            case 2: {
                this.HandleWinAckRecv(((TCMessage)pArg1).getMsgBuffer());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean HandleWinAckRecv(byte[] msgBuffer) {
        long uTime = TCChunkOutputStream.GETTIME();
        TCChunkOutputStream tCChunkOutputStream = this;
        synchronized (tCChunkOutputStream) {
            long uLastSeq = this.fAckState.fuLastAckSeq;
            long lBytesSent = this.fAckState.fuOutSeq - this.fAckState.fuLastWinStart;
            this.fAckState.fuLastWinStart = this.fAckState.fuOutSeq;
            this.fAckState.fuLastAckSeq = TCChunkOutputStream.Get4ByteInt(msgBuffer, 0);
            if (this.fAckState.fuLastAckSeq < uLastSeq) {
                this.fAckState.fuOutSeq -= uLastSeq;
                this.fAckState.fuWinLimit = 0L;
            }
            long uRange = (long)this.fAckState.fuAckWindow - (this.fAckState.fuOutSeq - this.fAckState.fuLastAckSeq);
            long uTimeDiff = uTime - this.fAckState.fuWindowStart;
            this.fAckState.fuWindowStart = uTime;
            long uExcess = (long)this.fAckState.fuAckWindow * uTimeDiff / 1000L;
            uExcess = lBytesSent <= uExcess ? 0L : lBytesSent - uExcess;
            this.fAckState.fuWinLimit = uRange < 0L ? 0L : TCChunkOutputStream.CoreMax((long)this.fAckState.fuAckWindow - uExcess, uRange - (long)(this.fAckState.fuAckWindow >> 1) + 1L);
            this.fAckState.fuWinLimit += this.fAckState.fuOutSeq;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SetBWLimit(long uUpBytes, long uDownBytes, short uType) {
        if (uUpBytes > 0L) {
            uUpBytes = TCChunkOutputStream.CoreMax(1000L, uUpBytes);
            TCChunkOutputStream tCChunkOutputStream = this;
            synchronized (tCChunkOutputStream) {
                int uOldWindow = this.fAckState.fuAckWindow;
                if (uType == 0 || uType == 1) {
                    this.fAckState.fuUserUpBWLimit = (int)uUpBytes;
                    boolean bl = this.fAckState.fbOverRide = uType == 0;
                    if (this.fAckState.fbOverRide) {
                        this.fAckState.fuAckWindow = (int)uUpBytes;
                    } else if ((long)this.fAckState.fuAckWindow > uUpBytes) {
                        this.fAckState.fuAckWindow = (int)uUpBytes;
                    }
                } else if (this.fAckState.fbOverRide && (long)this.fAckState.fuAckWindow != uUpBytes) {
                    this.fAckState.fuAckWindow = (int)uUpBytes;
                }
                if (uOldWindow != this.fAckState.fuAckWindow) {
                    this.fAckState.fuWinLimit += (long)this.fAckState.fuAckWindow;
                    this.SetPeerWindow(this.fAckState.fuAckWindow);
                }
            }
        }
        if (uDownBytes > 0L) {
            uDownBytes = TCChunkOutputStream.CoreMax(1000L, uDownBytes);
            TCMessage pMsg = new TCMessage();
            byte[] data = new byte[]{(byte)(uDownBytes >> 24), (byte)(uDownBytes >> 16), (byte)(uDownBytes >> 8), (byte)uDownBytes, (byte)uType};
            pMsg.write(data, 5);
            pMsg.setMsgID(6);
            this.QueueProtocolMsg(pMsg);
        }
        return true;
    }

    public int GetMeasuredBW() {
        return this.fAckState.fuMeasuredBW;
    }

    public int GetUpStrmBW() {
        return this.fAckState.fuAckWindow;
    }

    public int GetDownStrmBW() {
        return this.fAckState.fuDownStrmBW;
    }

    public int GetLatency() {
        return this.fAckState.fuUpRTT >> 1;
    }

    public synchronized void SetDefBandwidth(long uUpBytes, long uDownBytes) {
        if (uUpBytes > 1000L) {
            this.fAckState.fuDefUpBW = (int)uUpBytes;
        }
        if (uDownBytes > 1000L) {
            this.fAckState.fuDefDownBW = (int)uDownBytes;
        }
        this.fAckState.fuDownStrmBW = this.fAckState.fuDefDownBW;
        this.SetBWLimit(this.fAckState.fuDefUpBW, this.fAckState.fuDefDownBW, (short)2);
    }

    public synchronized boolean SetClientMode() {
        this.fAckState.fbClientMode = true;
        this.fAckState.fbState = 1;
        return true;
    }

    private TChunkContext SelectContext(boolean[] pbNewMsg) {
        TChunkContext result = null;
        pbNewMsg[0] = false;
        if (this.fpContexts != null) {
            this.HandleUnregistration();
            TChunkContext i = this.fpContexts;
            while (i != null) {
                i.fbEmpty = false;
                i = i.fpNext;
            }
            while (result == null) {
                i = this.fpContexts;
                while (i != null) {
                    if (!i.fbEmpty && (result == null || i.ScheduleStatus(this.fPriorityTotal) < result.ScheduleStatus(this.fPriorityTotal))) {
                        result = i;
                    }
                    i = i.fpNext;
                }
                if (result == null) break;
                if (result.fpMsg == null) {
                    result.fpMsg = result.GetNextMessage();
                    if (result.fpMsg != null) {
                        pbNewMsg[0] = true;
                        result.fOutMsgTime -= (long)this.fTimeBasis;
                    }
                }
                if (result.fpMsg == null) {
                    result.fbEmpty = true;
                    result = null;
                    continue;
                }
                ++result.fCount;
                i = this.fpContexts;
                while (i != null) {
                    if (i.fChunkStreamId == this.fScheduleHistory[this.fScheduleIndex]) {
                        --i.fCount;
                        break;
                    }
                    i = i.fpNext;
                }
                assert (result.fChunkStreamId != 0);
                this.fScheduleHistory[this.fScheduleIndex] = (byte)result.fChunkStreamId;
                ++this.fScheduleIndex;
                this.fScheduleIndex %= 100;
            }
        }
        return result;
    }

    private void ClearSchedule() {
        TChunkContext i = this.fpContexts;
        while (i != null) {
            i.fCount = 0;
            i = i.fpNext;
        }
        Arrays.fill(this.fScheduleHistory, (byte)0);
        this.fScheduleIndex = 0;
    }

    private boolean Write(byte[] buffer, int[] pInset, int[] pBytesNeeded, boolean[] pbDidWrite) {
        if (pBytesNeeded[0] != 0) {
            int bytesWritten = this.fWrite.doWrite(this.fWriteContext, buffer, pInset[0], pBytesNeeded[0]);
            pInset[0] = pInset[0] + bytesWritten;
            pBytesNeeded[0] = pBytesNeeded[0] - bytesWritten;
            pbDidWrite[0] = true;
            this.fAckState.fuOutSeq += (long)bytesWritten;
        }
        return pBytesNeeded[0] == 0;
    }

    private synchronized void QueueProtocolMsg(TCMessage pMsg) {
        if (this.fpProtocolQueue == null) {
            this.fpProtocolQueue = new TMsgList(pMsg);
        } else {
            TMsgList pCur = this.fpProtocolQueue;
            TMsgList pNext = this.fpProtocolQueue;
            while (pNext != null) {
                pCur = pNext;
                pNext = pNext.fpNext;
            }
            pCur.fpNext = new TMsgList(pMsg);
        }
    }

    private synchronized void QueueUserCtlMsg(TCMessage pMsg) {
        if (this.fpUserCtlMsgQueue == null) {
            this.fpUserCtlMsgQueue = new TMsgList(pMsg);
        } else {
            TMsgList pCur = this.fpUserCtlMsgQueue;
            TMsgList pNext = this.fpUserCtlMsgQueue;
            while (pNext != null) {
                pCur = pNext;
                pNext = pNext.fpNext;
            }
            pCur.fpNext = new TMsgList(pMsg);
        }
    }

    private void ApplyProtocolMsg(TCMessage pMsg) {
        switch (pMsg.getMsgID()) {
            case 1: {
                byte[] msgBuffer = pMsg.getMsgBuffer();
                this.fState.fMaxChunkSize = TCChunkOutputStream.Get4ByteInt(msgBuffer, 0);
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                this.fAckState.fboolSendAck = false;
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void HandleUnregistration() {
        boolean bDidUnregister = false;
        TChunkContext i = this.fpContexts;
        while (i != null) {
            if (i.fbUnregister) {
                if (i.fpMsg != null) {
                    TCMessage pMsg = new TCMessage();
                    pMsg.setMsgID(2);
                    byte[] data = new byte[]{(byte)(i.fChunkStreamId >> 24), (byte)(i.fChunkStreamId >> 16), (byte)(i.fChunkStreamId >> 8), (byte)i.fChunkStreamId};
                    pMsg.write(data);
                    this.QueueProtocolMsg(pMsg);
                }
                TChunkContext kill = i;
                this.fPriorityTotal -= kill.fPriority;
                bDidUnregister = true;
                i = i.fpNext;
                kill.Release();
                if (kill != this.fpContexts) continue;
                this.fpContexts = null;
                continue;
            }
            i = i.fpNext;
        }
        if (bDidUnregister) {
            this.ClearSchedule();
        }
    }

    private boolean DoConnectAck(byte fbVersion) {
        if (!this.fbSentVersionByte) {
            byte[] versionByte = new byte[]{fbVersion};
            int[] pInset = new int[]{0};
            int[] pBytesNeeded = new int[]{1};
            boolean[] bDidWrite = new boolean[]{false};
            this.fbSentVersionByte = this.Write(versionByte, pInset, pBytesNeeded, bDidWrite);
            assert (this.fbSentVersionByte);
            if (!this.fbSentVersionByte) {
                return false;
            }
            if (fbVersion >= 3) {
                byte[] data = new byte[1536];
                long uTime = TCChunkOutputStream.GETTIME();
                data[0] = (byte)(uTime >> 24);
                data[1] = (byte)(uTime >> 16);
                data[2] = (byte)(uTime >> 8);
                data[3] = (byte)uTime;
                data[7] = 0;
                data[6] = 0;
                data[5] = 0;
                data[4] = 0;
                byte lastVal = (byte)uTime;
                for (int i = 8; i < data.length; i += 2) {
                    data[i] = (byte)((lastVal * 12111221 + 1) % 256);
                    lastVal = data[i];
                }
                pInset[0] = 0;
                pBytesNeeded[0] = data.length;
                this.fbSentVersionByte = this.Write(data, pInset, pBytesNeeded, bDidWrite);
                if (!this.fbSentVersionByte) {
                    return false;
                }
            }
        }
        return this.fbSentVersionByte;
    }

    private void SetPeerWindow(int uSize) {
        TCMessage pMsg = new TCMessage();
        byte[] data = new byte[]{(byte)(uSize >> 24), (byte)(uSize >> 16), (byte)(uSize >> 8), (byte)uSize};
        pMsg.write(data, 4);
        pMsg.setMsgID(5);
        this.QueueProtocolMsg(pMsg);
    }

    private boolean HandleConnectReq(byte bVersion) {
        return bVersion >= 3;
    }

    private synchronized boolean HandleConnectAck(byte[] pAckData, long uReadTime) {
        this.fAckState.fpPingBuffer = new byte[1536];
        System.arraycopy(pAckData, 0, this.fAckState.fpPingBuffer, 0, 1536);
        this.fAckState.fpPingBuffer[4] = (byte)(uReadTime >> 24);
        this.fAckState.fpPingBuffer[5] = (byte)(uReadTime >> 16);
        this.fAckState.fpPingBuffer[6] = (byte)(uReadTime >> 8);
        this.fAckState.fpPingBuffer[7] = (byte)uReadTime;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean HandleConnectAckRecv(byte[] pAckData) {
        byte[] pVal = pAckData;
        long u1 = this.S2U(TCChunkOutputStream.Get4ByteInt(pVal[0], pVal[1], pVal[2], pVal[3]));
        long u2 = this.S2U(TCChunkOutputStream.Get4ByteInt(pVal[4], pVal[5], pVal[6], pVal[7]));
        long u3 = TCChunkOutputStream.GETTIME();
        TCChunkOutputStream tCChunkOutputStream = this;
        synchronized (tCChunkOutputStream) {
            this.fAckState.fuUpRTT = (int)(u3 - u1 - u2);
            long uRate = 128000000L;
            if (u2 > 0L) {
                uRate = (int)(1536.0 / (double)u2 * 1000.0);
            }
            this.fAckState.fuMeasuredBW = (int)(uRate + uRate / 1000L * (long)(this.fAckState.fuUpRTT >> 2));
            this.fAckState.fuMeasuredBW = TCChunkOutputStream.CoreMax(1000, this.fAckState.fuMeasuredBW);
            return true;
        }
    }
}

