/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.shared;

import com.macromedia.fcs.shared.ChunkCommon;
import com.macromedia.fcs.shared.TCMessage;
import com.macromedia.fcs.shared.TChunkContext;
import com.macromedia.fcs.shared.TChunkIOState;
import com.macromedia.fcs.shared.TChunkInFlowCtl;
import com.macromedia.fcs.shared.TReadProc;
import java.util.Arrays;

public class TCChunkInputStream
extends ChunkCommon {
    private TChunkContext fpContexts = null;
    private TChunkContext fpActive = null;
    private TReadProc fRead = null;
    private Object fReadContext = null;
    private TChunkIOState fState = new TChunkIOState();
    private byte fVersionByte = 0;
    private TChunkInFlowCtl fAckState = new TChunkInFlowCtl();
    private boolean fbHadError = false;

    public TCChunkInputStream() {
        this.fState.fStage = 1;
    }

    public void SetCallbacks(TReadProc readProc, Object context) {
        this.fRead = readProc;
        this.fReadContext = context;
    }

    public TCMessage ReadMessage(boolean[] pbBytesRemaining) {
        if (this.fbHadError) {
            return null;
        }
        TCMessage retval = null;
        byte[] fVersionByteBuf = new byte[1];
        int[] inset = new int[]{0};
        int[] bytesNeeded = new int[]{1};
        pbBytesRemaining[0] = true;
        boolean[] bContinue = new boolean[]{true};
        while (retval == null && bContinue[0]) {
            int bufferSizeNeeded;
            boolean readret;
            if (this.fVersionByte == 0) {
                inset[0] = 0;
                bytesNeeded[0] = 1;
                fVersionByteBuf[0] = this.fVersionByte;
                readret = this.Read(fVersionByteBuf, inset, bytesNeeded, pbBytesRemaining, bContinue);
                this.fVersionByte = fVersionByteBuf[0];
                if (!readret) continue;
                assert (this.fVersionByte <= 3);
                if (this.fVersionByte > 3) {
                    this.fbHadError = true;
                    return null;
                }
                if (this.fVersionByte < 3) {
                    this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 6, fVersionByteBuf, null);
                    this.fAckState.fboolEnableAck = false;
                    this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 3, null, null);
                    continue;
                }
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 6, fVersionByteBuf, null);
                continue;
            }
            if (this.fVersionByte >= 3 && this.fAckState.fuPingSize > 0) {
                if (this.fAckState.fuPingSize > 1536) {
                    bytesNeeded[0] = this.fAckState.fuPingSize - 1536;
                    inset[0] = 1536 - bytesNeeded[0];
                    if (inset[0] == 0) {
                        this.fAckState.fuReadTime = TCChunkInputStream.GETTIME();
                    }
                    if (this.Read(this.fAckState.fpPingBuffer, inset, bytesNeeded, pbBytesRemaining, bContinue)) {
                        this.fAckState.fuReadTime = TCChunkInputStream.GETTIME() - this.fAckState.fuReadTime;
                        this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 7, this.fAckState.fpPingBuffer, new Long(this.fAckState.fuReadTime));
                        this.fAckState.fuPingSize = 1536;
                        continue;
                    }
                    this.fAckState.fuPingSize = 3072 - inset[0];
                    continue;
                }
                inset[0] = 1536 - this.fAckState.fuPingSize;
                int[] pfuPingSize = new int[]{this.fAckState.fuPingSize};
                readret = this.Read(this.fAckState.fpPingBuffer, inset, pfuPingSize, pbBytesRemaining, bContinue);
                this.fAckState.fuPingSize = pfuPingSize[0];
                if (!readret) continue;
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 8, this.fAckState.fpPingBuffer, null);
                this.fAckState.fpPingBuffer = null;
                continue;
            }
            if (this.fState.fStage == 1) {
                assert (this.fpActive == null);
                if (this.fpActive != null) {
                    this.fbHadError = true;
                    return null;
                }
                inset[0] = 0;
                bytesNeeded[0] = 1;
                Arrays.fill(this.fState.fControlData, (byte)0);
                if (!this.Read(this.fState.fControlData, inset, bytesNeeded, pbBytesRemaining, bContinue)) continue;
                this.fState.fInset = 1;
                this.fState.fStage = 2;
                this.fState.fBytesNeeded = 0;
                int streamId = this.fState.fControlData[0] & 0x3F;
                if (streamId == 0) {
                    this.fState.fBytesNeeded = 1;
                }
                if (streamId != 1) continue;
                this.fState.fBytesNeeded = 2;
                continue;
            }
            if (this.fState.fStage == 2) {
                inset[0] = this.fState.fInset;
                bytesNeeded[0] = this.fState.fBytesNeeded;
                readret = this.Read(this.fState.fControlData, inset, bytesNeeded, pbBytesRemaining, bContinue);
                this.fState.fInset = inset[0];
                this.fState.fBytesNeeded = bytesNeeded[0];
                if (!readret) continue;
                int streamId = this.fState.fControlData[0] & 0x3F;
                if (streamId == 0 || streamId == 1) {
                    streamId = 64 + this.S2U(this.fState.fControlData[1]) + 256 * this.S2U(this.fState.fControlData[2]);
                }
                TChunkContext i = this.fpContexts;
                while (i != null) {
                    if (i.fChunkStreamId == streamId) {
                        this.fpActive = i;
                        break;
                    }
                    i = i.fpNext;
                }
                if (this.fpActive == null) {
                    this.fpActive = new TChunkContext();
                    this.fpActive.fChunkStreamId = streamId;
                    this.fpActive.fpNext = this.fpContexts;
                    this.fpContexts = this.fpActive;
                }
                int controlType = this.fState.fControlData[0] & 0xC0;
                this.fState.fInset = 0;
                this.fState.fStage = 3;
                this.fState.fBytesNeeded = this.fpActive.GetHeaderSize(controlType);
                if (controlType != 0) continue;
                this.fpActive.fMsgTime = 0L;
                continue;
            }
            if (this.fState.fStage == 3) {
                inset[0] = this.fState.fInset;
                bytesNeeded[0] = this.fState.fBytesNeeded;
                readret = this.Read(this.fpActive.fHeader, inset, bytesNeeded, pbBytesRemaining, bContinue);
                this.fState.fInset = inset[0];
                this.fState.fBytesNeeded = bytesNeeded[0];
                if (!readret) continue;
                this.fState.fInset = 0;
                this.fState.fStage = 4;
                this.fState.fBytesNeeded = this.fpActive.HasExtendedTimestamp() ? 4 : 0;
                continue;
            }
            if (this.fState.fStage == 4) {
                inset[0] = this.fState.fInset;
                bytesNeeded[0] = this.fState.fBytesNeeded;
                readret = this.Read(this.fpActive.fExtendedTimestamp, inset, bytesNeeded, pbBytesRemaining, bContinue);
                this.fState.fInset = inset[0];
                this.fState.fBytesNeeded = bytesNeeded[0];
                if (!readret) continue;
                if (this.fpActive.fpMsg == null) {
                    this.fpActive.fpMsg = new TCMessage();
                    this.fpActive.fMsgTime += (long)this.fpActive.GetMsgDelta();
                    this.fpActive.fMsgInset = 0;
                    this.fpActive.fpMsg.setMsgID(this.fpActive.GetMsgTypeId());
                    this.fpActive.fpMsg.setMsgTime(this.fpActive.fMsgTime);
                    this.fpActive.fpMsg.setStreamID(this.fpActive.GetMsgStreamId());
                    int newMsgLen = this.fpActive.GetMsgLen();
                    if (newMsgLen > 0xA00000) {
                        this.fbHadError = true;
                        return null;
                    }
                    if (newMsgLen < 65536) {
                        this.fpActive.fpMsg.setSize(newMsgLen);
                    } else {
                        this.fpActive.fpMsg.setSize(65536);
                        this.fpActive.fpMsg.setMsgLen(newMsgLen);
                    }
                }
                this.fState.fStage = 5;
                int messageBytesLeft = this.fpActive.GetMsgLen() - this.fpActive.fMsgInset;
                if (messageBytesLeft < 0) {
                    this.fbHadError = true;
                    return null;
                }
                this.fState.fBytesNeeded = TCChunkInputStream.CoreMin(this.fState.fMaxChunkSize, messageBytesLeft);
                this.fState.fInset = 0;
                continue;
            }
            if (this.fState.fStage == 0) continue;
            int bufferByteSize = this.fpActive.fpMsg.getBufferSize();
            if (bufferByteSize < (bufferSizeNeeded = this.fpActive.fMsgInset + this.fState.fBytesNeeded)) {
                int sizeToAlloc = TCChunkInputStream.CoreMax(bufferByteSize + bufferByteSize, bufferSizeNeeded);
                if (!this.fpActive.fpMsg.reallocBuffer(sizeToAlloc = TCChunkInputStream.CoreMin(sizeToAlloc, this.fpActive.GetMsgLen()))) {
                    this.fbHadError = true;
                    return null;
                }
            }
            inset[0] = this.fState.fInset;
            bytesNeeded[0] = this.fState.fBytesNeeded;
            readret = this.Read(this.fpActive.fpMsg.getMsgBuffer(), this.fpActive.fMsgInset, inset, bytesNeeded, pbBytesRemaining, bContinue);
            this.fState.fInset = inset[0];
            this.fState.fBytesNeeded = bytesNeeded[0];
            if (!readret) continue;
            this.fpActive.fMsgInset += this.fState.fInset;
            if (this.fpActive.fMsgInset == this.fpActive.GetMsgLen()) {
                if (this.fpActive.fChunkStreamId == 2) {
                    this.ApplyProtocolMsg(this.fpActive.fpMsg);
                } else {
                    retval = this.fpActive.fpMsg;
                }
                this.fpActive.fpMsg = null;
            }
            this.fState.fStage = 1;
            this.fpActive = null;
        }
        return retval;
    }

    public void Reset() {
        this.fpActive = null;
        this.fpContexts = null;
    }

    public boolean HadError() {
        return this.fbHadError;
    }

    public TChunkInFlowCtl GetAckContext() {
        return this.fAckState;
    }

    public void TriggerAck() {
        this.TriggerAck(1);
    }

    public void TriggerAck(int uEvery) {
        if (this.fAckState.fboolEnableAck && this.fAckState.fuInReadSeq - this.fAckState.fuLastAckSeq > this.fAckState.fuAckWindow >> uEvery) {
            if (this.fAckState.fuInReadSeq > -268435457L) {
                this.fAckState.fuInReadSeq -= this.fAckState.fuLastAckSeq;
                this.fAckState.fuLastAckSeq = this.fAckState.fuInReadSeq;
            }
            this.fAckState.fuLastAckSeq = this.fAckState.fuInReadSeq;
            TCMessage pMsg = new TCMessage();
            byte[] data = new byte[]{(byte)(this.fAckState.fuLastAckSeq >> 24), (byte)(this.fAckState.fuLastAckSeq >> 16), (byte)(this.fAckState.fuLastAckSeq >> 8), (byte)this.fAckState.fuLastAckSeq};
            pMsg.write(data);
            this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 1, pMsg, null);
        }
    }

    private boolean Read(byte[] buffer, int[] pInset, int[] pBytesNeeded, boolean[] pbBytesRemaining, boolean[] pbContinue) {
        return this.Read(buffer, 0, pInset, pBytesNeeded, pbBytesRemaining, pbContinue);
    }

    private boolean Read(byte[] buffer, int offset, int[] pInset, int[] pBytesNeeded, boolean[] pbBytesRemaining, boolean[] pbContinue) {
        if (pBytesNeeded[0] != 0) {
            int bytesRead = this.fRead.doRead(this.fReadContext, buffer, pInset[0] + offset, pBytesNeeded[0], pbBytesRemaining);
            pBytesNeeded[0] = pBytesNeeded[0] - bytesRead;
            pInset[0] = pInset[0] + bytesRead;
            assert (pBytesNeeded[0] >= 0);
            if (pBytesNeeded[0] < 0) {
                this.fbHadError = true;
            }
            this.fAckState.fuInReadSeq += (long)bytesRead;
        }
        pbContinue[0] = pBytesNeeded[0] == 0;
        return pbContinue[0];
    }

    private void ApplyProtocolMsg(TCMessage pMsg) {
        switch (pMsg.getMsgID()) {
            case 1: {
                byte[] msgBuffer = pMsg.getMsgBuffer();
                this.fState.fMaxChunkSize = TCChunkInputStream.Get4ByteInt(msgBuffer, 0);
                break;
            }
            case 2: {
                byte[] msgBuffer = pMsg.getMsgBuffer();
                int chunkStreamId = TCChunkInputStream.Get4ByteInt(msgBuffer, 0);
                TChunkContext i = this.fpContexts;
                while (i != null) {
                    if (i.fChunkStreamId == chunkStreamId) {
                        i.fpMsg = null;
                    }
                    i = i.fpNext;
                }
                break;
            }
            case 3: {
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 2, pMsg, null);
                break;
            }
            case 6: {
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 9, pMsg, null);
                break;
            }
            case 5: {
                byte[] msgBuffer = pMsg.getMsgBuffer();
                this.fAckState.fuAckWindow = TCChunkInputStream.Get4ByteInt(msgBuffer, 0);
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 10, new Long(this.fAckState.fuAckWindow), null);
                this.TriggerAck();
                break;
            }
            case 4: {
                this.fAckState.fpAckNotify.onAck(this.fAckState.fpContext, 5, pMsg, null);
                break;
            }
            default: {
                assert (false);
                this.fbHadError = true;
            }
        }
    }
}

