/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.common;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public abstract class SSLProvider
implements Runnable {
    final SSLEngine engine;
    final Executor ioWorker;
    final Executor taskWorkers;
    final ByteBuffer clientWrap;
    final ByteBuffer clientUnwrap;
    final ByteBuffer serverWrap;
    final ByteBuffer serverUnwrap;

    public SSLProvider(SSLEngine engine, int capacity, Executor ioWorker, Executor taskWorkers) {
        this.clientWrap = ByteBuffer.allocate(capacity);
        this.serverWrap = ByteBuffer.allocate(capacity);
        this.clientUnwrap = ByteBuffer.allocate(capacity);
        this.serverUnwrap = ByteBuffer.allocate(capacity);
        this.clientUnwrap.limit(0);
        this.engine = engine;
        this.ioWorker = ioWorker;
        this.taskWorkers = taskWorkers;
        this.ioWorker.execute(this);
    }

    public abstract void onInput(ByteBuffer var1);

    public abstract void onOutput(ByteBuffer var1);

    public abstract void onFailure(Exception var1);

    public abstract void onSuccess();

    public abstract void onClosed();

    public void sendAsync(final ByteBuffer data) {
        this.ioWorker.execute(new Runnable(){

            @Override
            public void run() {
                SSLProvider.this.clientWrap.put(data);
                SSLProvider.this.run();
            }
        });
    }

    public void notify(final ByteBuffer data) {
        this.ioWorker.execute(new Runnable(){

            @Override
            public void run() {
                SSLProvider.this.clientUnwrap.put(data);
                SSLProvider.this.run();
            }
        });
    }

    @Override
    public void run() {
        while (this.isHandShaking()) {
        }
    }

    private synchronized boolean isHandShaking() {
        switch (this.engine.getHandshakeStatus()) {
            case NOT_HANDSHAKING: {
                boolean occupied = false;
                if (this.clientWrap.position() > 0) {
                    occupied |= this.wrap();
                }
                if (this.clientUnwrap.position() > 0) {
                    occupied |= this.unwrap();
                }
                return occupied;
            }
            case NEED_WRAP: {
                if (this.wrap()) break;
                return false;
            }
            case NEED_UNWRAP: {
                if (this.unwrap()) break;
                return false;
            }
            case NEED_TASK: {
                final Runnable sslTask = this.engine.getDelegatedTask();
                Runnable wrappedTask = new Runnable(){

                    @Override
                    public void run() {
                        sslTask.run();
                        SSLProvider.this.ioWorker.execute(SSLProvider.this);
                    }
                };
                this.taskWorkers.execute(wrappedTask);
                return false;
            }
            case FINISHED: {
                throw new IllegalStateException("FINISHED");
            }
        }
        return true;
    }

    private boolean wrap() {
        SSLEngineResult wrapResult;
        try {
            this.clientWrap.flip();
            wrapResult = this.engine.wrap(this.clientWrap, this.serverWrap);
            this.clientWrap.compact();
        }
        catch (SSLException exc) {
            this.onFailure(exc);
            return false;
        }
        switch (wrapResult.getStatus()) {
            case OK: {
                if (this.serverWrap.position() <= 0) break;
                this.serverWrap.flip();
                this.onOutput(this.serverWrap);
                this.serverWrap.compact();
                break;
            }
            case BUFFER_UNDERFLOW: {
                break;
            }
            case BUFFER_OVERFLOW: {
                throw new IllegalStateException("failed to wrap");
            }
            case CLOSED: {
                this.onClosed();
                return false;
            }
        }
        return true;
    }

    private boolean unwrap() {
        SSLEngineResult unwrapResult;
        try {
            this.clientUnwrap.flip();
            unwrapResult = this.engine.unwrap(this.clientUnwrap, this.serverUnwrap);
            this.clientUnwrap.compact();
        }
        catch (SSLException ex) {
            this.onFailure(ex);
            return false;
        }
        switch (unwrapResult.getStatus()) {
            case OK: {
                if (this.serverUnwrap.position() <= 0) break;
                this.serverUnwrap.flip();
                this.onInput(this.serverUnwrap);
                this.serverUnwrap.compact();
                break;
            }
            case CLOSED: {
                this.onClosed();
                return false;
            }
            case BUFFER_OVERFLOW: {
                throw new IllegalStateException("failed to unwrap");
            }
            case BUFFER_UNDERFLOW: {
                return false;
            }
        }
        if (unwrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.onSuccess();
            return false;
        }
        return true;
    }
}

