/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.common;

import com.macromedia.fcs.common.SSLProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public abstract class NioSSLProvider
extends SSLProvider {
    private final ByteBuffer buffer = ByteBuffer.allocate(32768);
    private final SelectionKey key;

    public NioSSLProvider(SelectionKey key, SSLEngine engine, int bufferSize, Executor ioWorker, Executor taskWorkers) {
        super(engine, bufferSize, ioWorker, taskWorkers);
        this.key = key;
    }

    @Override
    public void onOutput(ByteBuffer encrypted) {
        try {
            ((WritableByteChannel)((Object)this.key.channel())).write(encrypted);
        }
        catch (IOException exc) {
            throw new IllegalStateException(exc);
        }
    }

    public boolean processInput() {
        int bytes;
        this.buffer.clear();
        try {
            bytes = ((ReadableByteChannel)((Object)this.key.channel())).read(this.buffer);
        }
        catch (IOException ex) {
            bytes = -1;
        }
        if (bytes == -1) {
            return false;
        }
        this.buffer.flip();
        ByteBuffer copy = ByteBuffer.allocate(bytes);
        copy.put(this.buffer);
        copy.flip();
        this.notify(copy);
        return true;
    }
}

