/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.common;

import com.macromedia.fcs.common.MethodStatRecord;
import com.macromedia.fcs.common.RtmpTransport;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodStats {
    private static HashMap<String, MethodStatRecord> methodTable = new HashMap();
    private static Logger _log = null;
    private static long lastDump = 0L;
    private static final long DUMP_SPAN = 30000L;

    public static synchronized void recordMethodMetric(String methodName, long executionTime) {
        try {
            MethodStatRecord msr = methodTable.get(methodName);
            if (msr == null) {
                msr = new MethodStatRecord();
                methodTable.put(methodName, msr);
            }
            msr.recordMetric(executionTime);
            if (System.currentTimeMillis() - lastDump > 30000L) {
                MethodStats.dumpMethodStats(0L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpMethodStats(long minAvg) {
        if (_log == null) {
            _log = LoggerFactory.getLogger(RtmpTransport.class);
        }
        for (String methodName : methodTable.keySet()) {
            MethodStatRecord msr = methodTable.get(methodName);
            if (minAvg != 0L && minAvg <= msr.avg) continue;
            _log.info("Method: " + methodName + " count: " + msr.count + " min: " + msr.min + " max: " + msr.max + " avg: " + msr.avg);
        }
        lastDump = System.currentTimeMillis();
    }

    public static ArrayList<MethodStatRecord> getMethodStats(long minAvg) {
        ArrayList<MethodStatRecord> list = new ArrayList<MethodStatRecord>();
        for (String methodName : methodTable.keySet()) {
            MethodStatRecord msr = methodTable.get(methodName);
            if (minAvg != 0L && minAvg <= msr.avg) continue;
            list.add(msr);
        }
        return list;
    }

    public static MethodStatRecord getMethodStat(String methodName) {
        return methodTable.get(methodName);
    }
}

