/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.common;

import com.macromedia.fcs.common.MethodStats;
import com.macromedia.fcs.common.OnMessageHandler;
import com.macromedia.fcs.common.OnRemoteCallHandler;
import com.macromedia.fcs.common.OnResultHandler;
import com.macromedia.fcs.common.OnStatusHandler;
import com.macromedia.fcs.common.OnSyncHandler;
import com.macromedia.fcs.common.RtmpTransport;
import com.macromedia.fcs.common.StatusInfo;
import com.macromedia.fcs.shared.Globals;
import com.macromedia.fcs.shared.TCCommand;
import com.macromedia.fcs.shared.TCJavaSerializer;
import com.macromedia.fcs.shared.TCMessage;
import com.macromedia.fcs.util.ThreadPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDispatcher
implements Globals {
    SyncCollection _onMessageSinks = new SyncCollection(new LinkedHashSet<Object>());
    SyncCollection _onUnhandledSinks = new SyncCollection(new LinkedHashSet<Object>());
    SyncCollection _containerSinks = new SyncCollection(new LinkedHashSet<Object>());
    SyncCollection _onStatusSinks = new SyncCollection(new LinkedHashSet<Object>());
    SyncCollection _onSyncSinks = new SyncCollection(new LinkedHashSet<Object>());
    SyncCollection _onRemoteCallSinks = new SyncCollection(new LinkedHashSet<Object>());
    Map<Integer, Object> _responseObjects = Collections.synchronizedMap(new HashMap());
    Map<Integer, Object> _pingResponseObjects = Collections.synchronizedMap(new HashMap());
    int _trxId = 100;
    ThreadPool _tpool;
    ThreadPool _ppool;
    private static Logger _log;

    public MessageDispatcher() {
        this._tpool = ThreadPool.get("FCSj_Worker");
        this._ppool = ThreadPool.get("FCSj_Ping");
        if (_log == null) {
            _log = LoggerFactory.getLogger(MessageDispatcher.class);
        }
    }

    public MessageDispatcher(ThreadPool tpool) {
        this._tpool = tpool;
        if (_log == null) {
            _log = LoggerFactory.getLogger(MessageDispatcher.class);
        }
    }

    public void registerSink(Object sink) {
        if (sink instanceof OnStatusHandler) {
            this._onStatusSinks.add(sink);
        }
        if (sink instanceof OnRemoteCallHandler) {
            this._onRemoteCallSinks.add(sink);
        }
        if (sink instanceof OnMessageHandler) {
            this._onMessageSinks.add(sink);
        }
        if (sink instanceof OnMessageHandler) {
            this._onUnhandledSinks.add(sink);
        }
        if (sink instanceof OnSyncHandler) {
            this._onSyncSinks.add(sink);
        }
    }

    public void registerContainerSink(OnMessageHandler sink) {
        this._containerSinks.add(sink);
    }

    public void unregisterSink(Object sink) {
        this._onStatusSinks.remove(sink);
        this._onRemoteCallSinks.remove(sink);
        this._onMessageSinks.remove(sink);
        this._onUnhandledSinks.remove(sink);
        this._containerSinks.remove(sink);
        this._onSyncSinks.remove(sink);
    }

    public synchronized Integer getNextTrxId() {
        return new Integer(this._trxId++);
    }

    public Integer registerResponseObject(Object responseObj) {
        Integer trxId = this.getNextTrxId();
        this._responseObjects.put(trxId, responseObj);
        return trxId;
    }

    public Integer registerPingResponseObject(Object responseObj) {
        Integer trxId = this.getNextTrxId();
        this._pingResponseObjects.put(trxId, responseObj);
        return trxId;
    }

    public void dispatch(RtmpTransport transport, TCMessage pMsg) {
        if (_log.isDebugEnabled()) {
            _log.debug("Message " + pMsg.getTime() + " " + pMsg.getType() + " " + pMsg.getMsgLen() + " dispatched");
        }
        Integer trxID = new Integer(0);
        if (pMsg.getType() == 20) {
            TCCommand cmdObj = new TCCommand(pMsg, transport.getObjectEncoding());
            String strCommand = cmdObj.getMethodName();
            if (cmdObj.getTrxID() != null) {
                trxID = new Integer(((Number)cmdObj.getTrxID()).intValue());
            }
        }
        if (this._pingResponseObjects.get(trxID) != null) {
            this._ppool.addTask(new DispatchPingTask(transport, pMsg));
        } else {
            this._tpool.addTask(new DispatchMessageTask(transport, pMsg));
        }
    }

    public boolean dispatchPingImmediate(RtmpTransport transport, TCMessage pMsg) {
        if (_log.isDebugEnabled()) {
            _log.debug("Dispatching Ping Message " + pMsg.getTime() + " " + pMsg.getType() + " " + pMsg.getMsgLen());
        }
        boolean bHandled = false;
        if (pMsg.getMsgID() == 20) {
            OnResultHandler orh;
            TCCommand cmdObj = new TCCommand(pMsg, transport.getObjectEncoding());
            String strCommand = cmdObj.getMethodName();
            Integer trxID = new Integer(0);
            if (cmdObj.getTrxID() != null) {
                trxID = new Integer(((Number)cmdObj.getTrxID()).intValue());
            }
            if (strCommand.equals("_result")) {
                if (_log.isDebugEnabled()) {
                    _log.debug("ping response received: " + trxID);
                }
                if ((orh = (OnResultHandler)this._pingResponseObjects.remove(trxID)) != null) {
                    orh.onResult(cmdObj.getArg(0));
                    bHandled = true;
                }
            } else if (strCommand.equals("_error")) {
                orh = (OnResultHandler)this._pingResponseObjects.remove(trxID);
                Map map = (Map)cmdObj.getArg(0);
                if (orh != null) {
                    orh.onStatus(new StatusInfo((String)map.get("level"), (String)map.get("code"), (String)map.get("description"), map.get("details")));
                    bHandled = true;
                }
            } else {
                if (_log.isDebugEnabled()) {
                    _log.debug("Not a ping response - method name: " + strCommand);
                }
                String methodName = cmdObj.getMethodName();
                Object[] args = new Object[cmdObj.getNumArgs()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = cmdObj.getArg(i);
                }
                bHandled = this.dispatchImmediate(transport, methodName, cmdObj.getTrxID(), args);
            }
            if (!bHandled) {
                _log.error("Unhandled command message");
                _log.error("method = " + cmdObj.getMethodName());
                _log.error("trxid = " + cmdObj.getTrxID());
                _log.error("cmdData = " + cmdObj.getCmdData());
                _log.error("numArgs = " + cmdObj.getNumArgs());
                _log.error("arg0 = " + cmdObj.getArg(0));
            }
        }
        if (!bHandled) {
            Iterator<Object> i = this._onUnhandledSinks.iterator();
            while (i.hasNext()) {
                OnMessageHandler omh = (OnMessageHandler)i.next();
                omh.onUnhandledMessage(pMsg);
            }
        }
        return true;
    }

    public boolean dispatchImmediate(RtmpTransport transport, TCMessage pMsg) {
        OnMessageHandler omh;
        Iterator<Object> i;
        RtmpTransport.Stream stream;
        if (_log.isDebugEnabled()) {
            _log.debug("Dispatching Message " + pMsg.getTime() + " " + pMsg.getType() + " " + pMsg.getMsgLen());
        }
        if ((stream = transport._streams.get(new Integer(pMsg.getStreamID()))) != null) {
            stream._time = pMsg.getTime();
            switch (pMsg.getMsgID()) {
                case 8: {
                    if (stream._recvAudio) break;
                    return true;
                }
                case 9: {
                    if (stream._recvVideo) break;
                    return true;
                }
                case 18: {
                    if (stream._recvData) break;
                    return true;
                }
            }
        }
        boolean bNeedProcessing = true;
        Iterator<Object> i2 = this._onMessageSinks.iterator();
        while (i2.hasNext()) {
            OnMessageHandler omh2 = (OnMessageHandler)i2.next();
            if (!omh2.onMessage(pMsg)) continue;
            bNeedProcessing = false;
        }
        if (!bNeedProcessing) {
            return true;
        }
        boolean bHandled = false;
        if (pMsg.getMsgID() == 20) {
            Map map;
            TCCommand cmdObj = new TCCommand(pMsg, transport.getObjectEncoding());
            String strCommand = cmdObj.getMethodName();
            Integer trxID = new Integer(0);
            if (cmdObj.getTrxID() != null) {
                trxID = new Integer(((Number)cmdObj.getTrxID()).intValue());
            }
            if (trxID == 1) {
                if (strCommand.equalsIgnoreCase("_result")) {
                    transport._connected = true;
                    RtmpTransport.Stream s0 = transport._stream0;
                    if (s0 != null) {
                        s0._blocked = false;
                    }
                } else if (strCommand.equalsIgnoreCase("_error")) {
                    transport._connected = false;
                }
                map = (Map)cmdObj.getArg(0);
                bHandled = this.dispatchImmediate(new StatusInfo((String)map.get("level"), (String)map.get("code"), (String)map.get("description"), map.get("details")));
            } else if (trxID != 0 || !strCommand.equalsIgnoreCase("close")) {
                OnResultHandler orh;
                if (trxID == 0 && strCommand.equals("onStatus")) {
                    map = (Map)cmdObj.getArg(0);
                    bHandled = this.dispatchImmediate(new StatusInfo((String)map.get("level"), (String)map.get("code"), (String)map.get("description"), map.get("details")));
                } else if (transport._pendingStreams.containsKey(trxID)) {
                    Integer sid = new Integer(((Number)cmdObj.getArg(0)).intValue());
                    _log.info("Server created stream " + sid);
                    RtmpTransport.Stream s = transport._pendingStreams.remove(trxID);
                    transport._streams.put(sid, s);
                    s.setStreamID(sid);
                    s._blocked = false;
                    bHandled = true;
                } else if (strCommand.equals("_result")) {
                    orh = (OnResultHandler)this._responseObjects.remove(trxID);
                    if (orh != null) {
                        orh.onResult(cmdObj.getArg(0));
                        bHandled = true;
                    }
                } else if (strCommand.equals("_error")) {
                    orh = (OnResultHandler)this._responseObjects.remove(trxID);
                    Map map2 = (Map)cmdObj.getArg(0);
                    if (orh != null) {
                        orh.onStatus(new StatusInfo((String)map2.get("level"), (String)map2.get("code"), (String)map2.get("description"), map2.get("details")));
                        bHandled = true;
                    }
                } else {
                    String methodName = cmdObj.getMethodName();
                    Object[] args = new Object[cmdObj.getNumArgs()];
                    for (int i3 = 0; i3 < args.length; ++i3) {
                        args[i3] = cmdObj.getArg(i3);
                    }
                    bHandled = this.dispatchImmediate(transport, methodName, cmdObj.getTrxID(), args);
                }
            }
            if (!bHandled) {
                _log.error("Unhandled command message");
                _log.error("method = " + cmdObj.getMethodName());
                _log.error("trxid = " + cmdObj.getTrxID());
                _log.error("cmdData = " + cmdObj.getCmdData());
                _log.error("numArgs = " + cmdObj.getNumArgs());
                _log.error("arg0 = " + cmdObj.getArg(0));
            }
        } else if (pMsg.getMsgID() == 18) {
            Object arg;
            TCJavaSerializer serializer = new TCJavaSerializer(pMsg.getMsgBuffer(), pMsg.getMsgLen(), transport.getObjectEncoding());
            String methodName = (String)serializer.GetVar(false);
            LinkedList<Object> argsList = new LinkedList<Object>();
            while ((arg = serializer.GetVar(false)) != TCJavaSerializer.END_MARKER) {
                argsList.add(arg);
            }
            bHandled = this.dispatchImmediate(transport, methodName, null, argsList.toArray());
        } else if (pMsg.getMsgID() == 19) {
            i = this._containerSinks.iterator();
            while (i.hasNext()) {
                omh = (OnMessageHandler)i.next();
                omh.onMessage(pMsg);
            }
        }
        if (!bHandled) {
            i = this._onUnhandledSinks.iterator();
            while (i.hasNext()) {
                omh = (OnMessageHandler)i.next();
                omh.onUnhandledMessage(pMsg);
            }
        }
        return true;
    }

    public void dispatch(StatusInfo statusInfo) {
        this._tpool.addTask(new DispatchStatusInfoTask(statusInfo));
    }

    public boolean dispatchImmediate(StatusInfo statusInfo) {
        Iterator<Object> it = this._onStatusSinks.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            ((OnStatusHandler)it.next()).onStatus(statusInfo);
        }
        return true;
    }

    public void dispatchSync(List<Object> syncInfoList) {
        this._tpool.addTask(new DispatchSyncTask(syncInfoList));
    }

    public boolean dispatchImmediateSync(List<Object> syncInfoList) {
        Iterator<Object> it = this._onSyncSinks.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            ((OnSyncHandler)it.next()).onSync(syncInfoList);
        }
        return true;
    }

    public void dispatch(RtmpTransport transport, String methodName, Object trxId, Object[] args) {
        this._tpool.addTask(new DispatchMethodTask(transport, methodName, trxId, args));
    }

    public boolean dispatchImmediate(RtmpTransport transport, String methodName, Object trxId, Object[] args) {
        boolean okCall;
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i] == null ? Object.class : args[i].getClass();
        }
        boolean bl = okCall = trxId == null;
        if (trxId != null && trxId instanceof Number && ((Number)trxId).intValue() == 0) {
            okCall = true;
        }
        Method method = null;
        Object result = null;
        Iterator<Object> it = this._onRemoteCallSinks.iterator();
        while (it.hasNext()) {
            OnRemoteCallHandler och = (OnRemoteCallHandler)it.next();
            Class<?> ochcls = och.getClass();
            try {
                method = MessageDispatcher.findMethod(ochcls, methodName, argTypes, args);
                long startTime = System.currentTimeMillis();
                result = method.invoke((Object)och, args);
                long executionTime = System.currentTimeMillis() - startTime;
                if (args.length > 0 && args[0] instanceof HashMap) {
                    MethodStats.recordMethodMetric((String)((HashMap)args[0]).get("method"), executionTime);
                } else {
                    MethodStats.recordMethodMetric(methodName, executionTime);
                }
                if (okCall) continue;
                this.sendResultMessage(transport, trxId, result);
                okCall = true;
                trxId = null;
                continue;
            }
            catch (NoSuchMethodException nsmx) {
            }
            catch (SecurityException sx) {
            }
            catch (IllegalAccessException iax) {
            }
            catch (InvocationTargetException itx) {
                // empty catch block
            }
            try {
                result = och.onResolve(methodName, args);
                if (okCall) continue;
                this.sendResultMessage(transport, trxId, result);
                okCall = true;
                trxId = null;
            }
            catch (NoSuchMethodException nsmx) {}
        }
        if (!okCall) {
            this.sendCallFailedMessage(transport, trxId, methodName);
            return false;
        }
        return true;
    }

    public void sendResultMessage(RtmpTransport transport, Object trxId, Object result) {
        TCCommand response = new TCCommand(transport.getObjectEncoding());
        response.setTrxID(trxId);
        response.setResponseSuccess();
        response.setUserArg(result);
        transport.queueCommandMessage(response.getCommandResponse());
    }

    public void sendCallFailedMessage(RtmpTransport transport, Object trxId, String methodName) {
        TCCommand response = new TCCommand(transport.getObjectEncoding());
        response.setTrxID(trxId);
        response.setResponseFailure();
        response.setInfoObj("error", "NetConnection.Call.Failed", "Invalid method name " + methodName);
        transport.queueCommandMessage(response.getCommandResponse());
        _log.error("NetConnection.Call.Failed, Invalid method name " + methodName);
    }

    public static Method findMethod(Class cls, String methodName, Class[] argTypes, Object[] argVals) throws NoSuchMethodException {
        try {
            return cls.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException nsmx) {
            Method[] allMethods = cls.getMethods();
            Method method = null;
            int closest = argTypes.length;
            block2: for (int i = 0; i < allMethods.length; ++i) {
                Class<?>[] parTypes = allMethods[i].getParameterTypes();
                if (!methodName.equals(allMethods[i].getName()) || parTypes.length != argTypes.length) continue;
                int distance = 0;
                for (int j = 0; j < argTypes.length; ++j) {
                    if (argVals[j] == null && !parTypes[j].isPrimitive() || parTypes[j] == Object.class || parTypes[j] == Boolean.TYPE && argTypes[j] == Boolean.class) continue;
                    if (!parTypes[j].isAssignableFrom(argTypes[j])) {
                        int dist = MessageDispatcher.getNumberTypeDistance(parTypes[j], argTypes[j]);
                        if (dist < 0) continue block2;
                        distance += dist;
                        continue;
                    }
                    if (parTypes[j] != argTypes[j]) {
                        ++distance;
                    }
                    if (distance > closest) continue block2;
                }
                if (distance >= closest) continue;
                closest = distance;
                method = allMethods[i];
            }
            if (method == null) {
                throw new NoSuchMethodException();
            }
            return method;
        }
    }

    public static int getNumberTypeDistance(Class dstType, Class<Double> srcType) {
        if (srcType != Double.class) {
            return -1;
        }
        if (dstType == Double.class || dstType == Double.TYPE) {
            return 0;
        }
        if (dstType == Long.class || dstType == Long.TYPE) {
            return 0;
        }
        if (dstType == Float.class || dstType == Float.TYPE) {
            return 1;
        }
        if (dstType == Integer.class || dstType == Integer.TYPE) {
            return 1;
        }
        if (dstType == Short.class || dstType == Short.TYPE) {
            return 2;
        }
        if (dstType == Byte.class || dstType == Byte.TYPE) {
            return 3;
        }
        return -1;
    }

    public static void adjustArguments(Class[] parTypes, Class[] argTypes, Object[] argVals) {
        for (int i = 0; i < argVals.length; ++i) {
            if (argVals[i] == null || !Number.class.isAssignableFrom(argTypes[i])) continue;
            if (parTypes[i] == Double.class || parTypes[i] == Double.TYPE) {
                argVals[i] = new Double(((Number)argVals[i]).doubleValue());
                continue;
            }
            if (parTypes[i] == Float.class || parTypes[i] == Float.TYPE) {
                argVals[i] = new Float(((Number)argVals[i]).floatValue());
                continue;
            }
            if (parTypes[i] == Long.class || parTypes[i] == Long.TYPE) {
                argVals[i] = new Long(((Number)argVals[i]).longValue());
                continue;
            }
            if (parTypes[i] == Integer.class || parTypes[i] == Integer.TYPE) {
                argVals[i] = new Integer(((Number)argVals[i]).intValue());
                continue;
            }
            if (parTypes[i] == Short.class || parTypes[i] == Short.TYPE) {
                argVals[i] = new Short(((Number)argVals[i]).shortValue());
                continue;
            }
            if (parTypes[i] != Byte.class && parTypes[i] != Byte.TYPE) continue;
            argVals[i] = new Byte(((Number)argVals[i]).byteValue());
        }
    }

    static class SyncCollection {
        Collection<Object> _r = null;
        Collection<Object> _w = null;

        SyncCollection(Collection<Object> c) {
            this._w = c != null ? c : new LinkedList();
        }

        public synchronized Iterator<Object> iterator() {
            if (this._r == null) {
                this._r = Collections.unmodifiableCollection(new LinkedList<Object>(this._w));
            }
            return this._r.iterator();
        }

        public synchronized boolean add(Object o) {
            this._r = null;
            return this._w.add(o);
        }

        public synchronized boolean remove(Object o) {
            this._r = null;
            return this._w.remove(o);
        }
    }

    class DispatchPingTask
    implements Runnable {
        RtmpTransport _transport;
        TCMessage _message;

        public DispatchPingTask(RtmpTransport transport, TCMessage mesg) {
            this._transport = transport;
            this._message = mesg;
        }

        @Override
        public void run() {
            MessageDispatcher.this.dispatchPingImmediate(this._transport, this._message);
        }
    }

    class DispatchMessageTask
    implements Runnable {
        RtmpTransport _transport;
        TCMessage _message;

        public DispatchMessageTask(RtmpTransport transport, TCMessage mesg) {
            this._transport = transport;
            this._message = mesg;
        }

        @Override
        public void run() {
            MessageDispatcher.this.dispatchImmediate(this._transport, this._message);
        }
    }

    class DispatchMethodTask
    implements Runnable {
        RtmpTransport _transport;
        String _methodName;
        Object _trxId;
        Object[] _args;

        public DispatchMethodTask(RtmpTransport transport, String methodName, Object trxId, Object[] args) {
            this._transport = transport;
            this._methodName = methodName;
            this._trxId = trxId;
            this._args = args;
        }

        @Override
        public void run() {
            MessageDispatcher.this.dispatchImmediate(this._transport, this._methodName, this._trxId, this._args);
        }
    }

    class DispatchSyncTask
    implements Runnable {
        List<Object> _list;

        public DispatchSyncTask(List<Object> list) {
            this._list = list;
        }

        @Override
        public void run() {
            MessageDispatcher.this.dispatchImmediateSync(this._list);
        }
    }

    class DispatchStatusInfoTask
    implements Runnable {
        StatusInfo _statusInfo;

        public DispatchStatusInfoTask(StatusInfo sinfo) {
            this._statusInfo = sinfo;
        }

        @Override
        public void run() {
            MessageDispatcher.this.dispatchImmediate(this._statusInfo);
        }
    }
}

