/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.client;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.common.OnResultHandler;
import com.macromedia.fcs.common.OnStatusHandler;
import com.macromedia.fcs.common.StatusInfo;

public class SyncNetConnection
extends NetConnection {
    long _connectTimeout = 20000L;
    long _callTimeout = 10000L;

    public SyncNetConnection() {
    }

    public SyncNetConnection(String type) {
        super(type);
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long timeout) {
        this._connectTimeout = timeout;
    }

    public long getCallTimeout() {
        return this._callTimeout;
    }

    public void setCallTimeout(long timeout) {
        this._callTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectWait(String uri, Object[] args, long timeout) throws RemoteException {
        OnStatus osh = new OnStatus();
        osh.statusInfo = new StatusInfo("error", "NetConnection.Connect.Failed", "Connection timed out.", null);
        OnStatus onStatus = osh;
        synchronized (onStatus) {
            try {
                this.registerSink(osh);
                super.connect(uri, args);
                osh.wait(timeout);
            }
            catch (Exception ie) {
                ie.printStackTrace();
                throw new RemoteException((Throwable)ie);
            }
            finally {
                this.unregisterSink(osh);
            }
            if (!osh.statusInfo.getCode().equals("NetConnection.Connect.Success")) {
                System.out.println(osh.statusInfo.getCode());
                throw new RemoteException(osh.statusInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callWait(String method, Object[] args, long timeout) throws RemoteException {
        OnResult orh = new OnResult();
        orh.statusInfo = new StatusInfo("error", "NetConnection.Call.Failed", "Call timed out.", null);
        OnResult onResult = orh;
        synchronized (onResult) {
            try {
                super.call(method, (OnResultHandler)orh, args);
                orh.wait(timeout);
            }
            catch (InterruptedException ie) {
                throw new RemoteException((Throwable)ie);
            }
            finally {
                this.unregisterSink(orh);
            }
            if (orh.statusInfo != null) {
                throw new RemoteException(orh.statusInfo);
            }
            return orh.result;
        }
    }

    public void connectWait(String uri) throws RemoteException {
        this.connectWait(uri, new Object[0]);
    }

    public void connectWait(String uri, Object arg0) throws RemoteException {
        this.connectWait(uri, new Object[]{arg0});
    }

    public void connectWait(String uri, Object arg0, Object arg1) throws RemoteException {
        this.connectWait(uri, new Object[]{arg0, arg1});
    }

    public void connectWait(String uri, Object arg0, Object arg1, Object arg2) throws RemoteException {
        this.connectWait(uri, new Object[]{arg0, arg1, arg2});
    }

    public void connectWait(String uri, Object[] args) throws RemoteException {
        this.connectWait(uri, args, this._connectTimeout);
    }

    public Object callWait(String method) throws RemoteException {
        return this.callWait(method, new Object[0]);
    }

    public Object callWait(String method, Object arg0) throws RemoteException {
        return this.callWait(method, new Object[]{arg0});
    }

    public Object callWait(String method, Object arg0, Object arg1) throws RemoteException {
        return this.callWait(method, new Object[]{arg0, arg1});
    }

    public Object callWait(String method, Object arg0, Object arg1, Object arg2) throws RemoteException {
        return this.callWait(method, new Object[]{arg0, arg1, arg2});
    }

    public Object callWait(String method, Object[] args) throws RemoteException {
        return this.callWait(method, args, this._callTimeout);
    }

    public class OnResult
    implements OnResultHandler {
        public boolean fired = false;
        public Object result = null;
        public StatusInfo statusInfo = null;

        @Override
        public synchronized void onStatus(StatusInfo sinfo) {
            if (this.fired) {
                return;
            }
            this.fired = true;
            this.statusInfo = sinfo;
            this.notify();
        }

        @Override
        public synchronized void onResult(Object res) {
            if (this.fired) {
                return;
            }
            this.fired = true;
            this.result = res;
            this.statusInfo = null;
            this.notify();
        }
    }

    public class OnStatus
    implements OnStatusHandler {
        public boolean fired = false;
        public StatusInfo statusInfo;

        @Override
        public synchronized void onStatus(StatusInfo sinfo) {
            if (this.fired) {
                return;
            }
            this.fired = true;
            this.statusInfo = sinfo;
            this.notify();
        }
    }

    public class RemoteException
    extends Exception {
        private static final long serialVersionUID = 3716557549388703968L;
        public StatusInfo statusInfo;

        RemoteException() {
            this.statusInfo = null;
        }

        RemoteException(Throwable t) {
            super(t);
            this.statusInfo = null;
        }

        RemoteException(StatusInfo info) {
            super(info.toString());
            this.statusInfo = null;
            this.statusInfo = info;
        }
    }
}

