/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.client;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.common.Message;
import com.macromedia.fcs.common.MessageDispatcher;
import com.macromedia.fcs.common.OnMessageHandler;
import com.macromedia.fcs.common.StatusInfo;
import com.macromedia.fcs.common.SyncInfo;
import com.macromedia.fcs.shared.Globals;
import com.macromedia.fcs.shared.TCJavaSerializer;
import com.macromedia.fcs.shared.TCMessage;
import com.macromedia.fcs.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedObject
implements Globals {
    private static Logger _log;
    public static final Storage ON_SERVER_ONLY;
    static final int kPersistClient = 1;
    static final int kPersistServer = 2;
    static final int kSharedLocal = 4;
    static final int kUnsupportedVersion = 1;
    static final int kSerializationVersion = 4;
    static final int kValid = 0;
    static final int kDirty = 1;
    static final int kWait = 2;
    static final String _illegalChars = "~&\\;:\"',<>? #";
    static final Set<String> _illegalNames;
    static Map<Handle, SharedObject> _sharedObjects;
    static Map<NetConnection, MessageHandler> _msgHandlers;
    String _name = null;
    int _flags = 0;
    int _magic = 0;
    long _version = -1L;
    Util.URI _remoteURI = null;
    Storage _storage = null;
    NetConnection _nc = null;
    MessageDispatcher _md = new MessageDispatcher();
    Map<String, Slot> _data = new HashMap<String, Slot>();
    boolean _waitForUseSuccess = false;
    boolean _waitingForOnSync = false;
    boolean _saveNeeded = false;
    boolean _autoUpdate = true;

    public static synchronized SharedObject getRemote(String name, String remotePath, Storage storageOption) {
        return SharedObject.getRemote(name, Util.parseURI(remotePath), storageOption);
    }

    public static synchronized SharedObject getRemote(String name, Util.URI remoteURI, Storage storageOption) {
        if (!SharedObject.isNameLegal(name)) {
            return null;
        }
        Handle h = new Handle(name, remoteURI, storageOption != null);
        if (!h.valid()) {
            return null;
        }
        SharedObject so = _sharedObjects.get(h);
        if (so != null) {
            return so;
        }
        so = new SharedObject(name, remoteURI, storageOption);
        _sharedObjects.put(h, so);
        return so;
    }

    SharedObject(String name, Util.URI remoteURI, Storage storageOption) {
        this._name = name;
        this._remoteURI = remoteURI;
        this._storage = storageOption;
        if (this._storage != null) {
            this._flags |= 2;
            if (this._storage != ON_SERVER_ONLY) {
                Data data = this._storage.load();
                if (data != null) {
                    this._magic = data.magic;
                    this._version = data.version;
                    this._data.putAll(data.slots);
                }
                this._flags |= 1;
            }
        }
        if (_log == null) {
            _log = LoggerFactory.getLogger(SharedObject.class);
        }
    }

    public static synchronized boolean remove(String name, Util.URI remoteURI, Storage storageOption) {
        Handle h = new Handle(name, remoteURI, storageOption != null);
        if (!h.valid()) {
            return false;
        }
        SharedObject so = _sharedObjects.get(h);
        if (so == null) {
            return false;
        }
        if (so._storage != null) {
            so._storage.remove();
        }
        _sharedObjects.remove(h);
        return true;
    }

    public synchronized boolean connect(NetConnection nc) {
        if (nc == null) {
            return false;
        }
        if (this._nc != null) {
            this.close();
        }
        if (!this._remoteURI.equalsIgnoreProto(nc.getURI())) {
            return false;
        }
        this._nc = nc;
        MessageHandler mh = _msgHandlers.get(nc);
        if (mh == null) {
            mh = new MessageHandler(nc.getURI(), this._nc._objectEncoding);
            _msgHandlers.put(nc, mh);
        }
        this._nc._messageDispatcher.registerContainerSink(mh);
        TCJavaSerializer js = new TCJavaSerializer(this._nc._objectEncoding);
        this.putHeader(js);
        js.PutByte((byte)1);
        js.PutDWord(0);
        TCMessage pMsg = new TCMessage();
        pMsg.setMsgID(19);
        pMsg.write(js.GetBuf(), js.GetPos());
        this._waitForUseSuccess = true;
        this._nc._rtmpStream.queueMessage(pMsg);
        return true;
    }

    public synchronized void close() {
        if ((this._flags & 1) != 0) {
            this.updateLocal();
        }
        if ((this._flags & 4) == 0) {
            this.updateServer();
            if (this._nc != null) {
                TCJavaSerializer js = new TCJavaSerializer(this._nc._objectEncoding);
                this.putHeader(js);
                js.PutByte((byte)2);
                js.PutDWord(0);
                TCMessage pMsg = new TCMessage();
                pMsg.setMsgID(19);
                pMsg.write(js.GetBuf(), js.GetPos());
                this._nc._rtmpStream.queueMessage(pMsg);
            }
        }
        this._waitForUseSuccess = false;
        this._nc = null;
    }

    public synchronized int getSize() {
        return 0;
    }

    public synchronized boolean flush() {
        this.updateLocal();
        return false;
    }

    public boolean send(String methodName, Object[] args) {
        TCJavaSerializer js = new TCJavaSerializer(this._nc._objectEncoding);
        this.putHeader(js);
        js.PutByte((byte)6);
        int savPos = js.GetPos();
        js.PutDWord(0);
        js.PutVar(methodName, false);
        for (int i = 0; i < args.length; ++i) {
            js.PutVar(args[i], false);
        }
        int lastPos = js.GetPos();
        js.SetPos(savPos);
        js.PutDWord(lastPos - savPos - 4);
        js.SetPos(lastPos);
        TCMessage pMsg = new TCMessage();
        pMsg.setMsgID(19);
        pMsg.write(js.GetBuf(), js.GetPos());
        this._nc._rtmpStream.queueMessage(pMsg);
        return true;
    }

    public synchronized void setAutoUpdate(boolean autoUpdate) {
        this._autoUpdate = autoUpdate;
    }

    public boolean isAutoUpdate() {
        return this._autoUpdate;
    }

    public synchronized void update() {
        this.updateServer();
    }

    public void registerSink(OnMessageHandler sink) {
        this._md.registerSink(sink);
    }

    public void unregisterSink(Object sink) {
        this._md.unregisterSink(sink);
    }

    public synchronized Object getProperty(String name) {
        Slot slot = this._data.get(name);
        if (slot == null) {
            return null;
        }
        return slot.value;
    }

    public synchronized void setProperty(String slotName, Object value) {
        Slot slot = this._data.get(slotName);
        if (slot == null) {
            slot = new Slot(1, value);
            this._data.put(slotName, slot);
        }
        slot.state |= 1;
        slot.value = value;
        if (this._autoUpdate) {
            this.updateServer(slotName, slot);
        }
    }

    public synchronized void setProperties(Map<Object, Object> props) {
        HashMap<String, Slot> changedSlots = new HashMap<String, Slot>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String slotName = (String)entry.getKey();
            Slot slot = (Slot)entry.getValue();
            if (slot == null) {
                slot = new Slot(1, entry.getValue());
                this._data.put(slotName, slot);
            }
            slot.state |= 1;
            slot.value = entry.getValue();
            changedSlots.put(slotName, slot);
        }
        if (this._autoUpdate) {
            this.updateServer(changedSlots.entrySet());
        }
    }

    static boolean isNameLegal(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isISOControl(c)) {
                return false;
            }
            if (_illegalChars.indexOf(c) < 0) continue;
            return false;
        }
        if (name.indexOf("//") >= 0) {
            return false;
        }
        int n = name.indexOf("../");
        if (n == 0) {
            return false;
        }
        return n <= 0 || name.charAt(n - 1) != '/';
    }

    synchronized boolean processMessage(TCMessage msg, TCJavaSerializer js, int endPos) {
        if (_log != null) {
            _log.info(this + ": processMessage called");
        }
        if (this._nc == null) {
            return false;
        }
        long version = (long)js.GetDWord() & 0xFFFFFFFFL;
        int flags = js.GetDWord();
        int magic = js.GetDWord();
        int eventPos = js.GetPos();
        this._magic = magic;
        String[] ps = new String[1];
        LinkedList<Object> syncInfoList = new LinkedList<Object>();
        boolean clearWaitFlag = false;
        boolean boolCallOnSync = false;
        block9: while (js.GetPos() < endPos) {
            int eventType = js.GetByte() & 0xFF;
            int dataLen = js.GetDWord();
            if (this._waitForUseSuccess && eventType != 11) {
                js.SetPos(js.GetPos() + dataLen);
                continue;
            }
            switch (eventType) {
                case 8: {
                    if (_log != null) {
                        _log.info("eventType: kEventClear");
                    }
                    this._data.clear();
                    clearWaitFlag = true;
                    boolCallOnSync = true;
                    syncInfoList.add(new SyncInfoImpl("clear", null, null));
                    this._saveNeeded = true;
                    break;
                }
                case 4: {
                    if (_log != null) {
                        _log.info("eventType: kEventChange");
                    }
                    Object slotValue = js.GetVar(ps, true);
                    String slotName = ps[0];
                    Slot slot = this._data.get(slotName);
                    SyncInfoImpl syncInfo = new SyncInfoImpl("change", slotName, null);
                    if (slot != null) {
                        syncInfo._oldValue = slot.value;
                        slot.value = slotValue;
                        if (slot.state != 0) {
                            syncInfo._code = "reject";
                            if ((slot.state & 2) != 0) {
                                clearWaitFlag = true;
                            }
                            slot.state = 0;
                        }
                    } else {
                        slot = new Slot(0, slotValue);
                    }
                    syncInfoList.add(syncInfo);
                    this._data.put(slotName, slot);
                    this._saveNeeded = true;
                    break;
                }
                case 11: {
                    if (_log != null) {
                        _log.info("eventType: kEventUseSuccess");
                    }
                    this._waitForUseSuccess = false;
                    boolCallOnSync = true;
                    clearWaitFlag = true;
                    break;
                }
                case 5: {
                    Slot slot;
                    String slotName;
                    if (_log != null) {
                        _log.info("eventType: kEventSuccess");
                    }
                    int pos = js.GetPos();
                    boolCallOnSync = js.GetPos() == pos + dataLen;
                    clearWaitFlag = true;
                    this._saveNeeded = true;
                    while (js.GetPos() < pos + dataLen) {
                        slotName = js.GetString(2);
                        slot = this._data.get(slotName);
                        if (slot == null) continue;
                        assert (slot.state != 0);
                        assert ((slot.state & 1) == 0);
                        if (slot.state == 2) {
                            syncInfoList.add(new SyncInfoImpl("success", slotName, null));
                            if (slot.value == null) {
                                this._data.remove(slotName);
                            }
                        }
                        slot.state &= 0xFFFFFFFD;
                    }
                    continue block9;
                }
                case 9: {
                    String slotName;
                    Slot slot;
                    if (_log != null) {
                        _log.info("eventType: kEventRemove");
                    }
                    if ((slot = this._data.get(slotName = js.GetString(2))) != null) {
                        syncInfoList.add(new SyncInfoImpl("delete", slotName, slot.value));
                        if ((slot.state & 2) != 0) {
                            clearWaitFlag = true;
                        }
                    }
                    this._saveNeeded = true;
                    break;
                }
                case 7: {
                    if (_log != null) {
                        _log.info("eventType: kEventStatus");
                    }
                    clearWaitFlag = true;
                    String code = js.GetString(2);
                    String level = js.GetString(2);
                    this._md.dispatch(new StatusInfo(level, code, null, null));
                    break;
                }
                case 6: {
                    if (_log != null) {
                        _log.info("eventType: kEventSendMsg");
                    }
                    this.dispatchSendMsg(js.GetBuf(), js.GetPos(), dataLen);
                    js.SetPos(js.GetPos() + dataLen);
                    break;
                }
                default: {
                    if (_log != null) {
                        _log.warn("eventType: Unknown event " + eventType);
                    }
                    assert (false);
                    js.SetPos(js.GetPos() + dataLen);
                }
            }
        }
        if (!syncInfoList.isEmpty() || boolCallOnSync) {
            this._md.dispatchSync(syncInfoList);
            this._saveNeeded = true;
        }
        if (clearWaitFlag) {
            this._waitingForOnSync = false;
            this.updateServer();
        }
        return true;
    }

    void dispatchSendMsg(byte[] buffer, int offset, int length) {
        TCJavaSerializer js = new TCJavaSerializer(buffer, offset + length, this._nc._objectEncoding);
        js.SetPos(offset);
        Object methodName = js.GetVar(false);
        LinkedList<Object> argsList = new LinkedList<Object>();
        while (js.GetPos() < offset + length) {
            argsList.add(js.GetVar(false));
        }
        if (methodName != null && methodName instanceof String && !_illegalNames.contains(methodName)) {
            this._md.dispatch(this._nc._rtmpTransport, (String)methodName, null, argsList.toArray());
        }
    }

    void updateLocal() {
        if (this._storage != null && this._storage != ON_SERVER_ONLY) {
            this._storage.store(new Data(this._name, this._remoteURI.toString(), this._magic, this._version, this._data));
        }
    }

    void putHeader(TCJavaSerializer js) {
        js.PutString(this._name);
        js.PutDWord((int)this._version);
        js.PutDWord(this._flags);
        js.PutDWord(this._magic);
    }

    boolean putSlot(TCJavaSerializer js, String slotName, Slot slot) {
        if (slot == null) {
            return false;
        }
        if ((slot.state & 2) != 0) {
            return false;
        }
        if ((slot.state & 1) != 0) {
            slot.state = 2;
        }
        int event = slot.value == null ? 10 : 3;
        js.PutByte((byte)event);
        int savPos = js.GetPos();
        js.PutDWord(0);
        if (event == 10) {
            js.PutString(slotName);
        } else {
            js.PutVar(slotName, slot.value, false);
        }
        int lastPos = js.GetPos();
        js.SetPos(savPos);
        js.PutDWord(lastPos - savPos - 4);
        js.SetPos(lastPos);
        return true;
    }

    boolean putSlots(TCJavaSerializer js, Collection<Map.Entry<String, Slot>> slots) {
        boolean result = false;
        for (Map.Entry<String, Slot> entry : slots) {
            if (!this.putSlot(js, entry.getKey(), entry.getValue())) continue;
            result = true;
        }
        return result;
    }

    void updateServer() {
        LinkedList<Map.Entry<String, Slot>> slots = new LinkedList<Map.Entry<String, Slot>>();
        for (Map.Entry<String, Slot> entry : this._data.entrySet()) {
            Slot slot = entry.getValue();
            if (slot.state != 1) continue;
            slots.add(entry);
        }
        this.updateServer(slots);
    }

    void updateServer(Collection<Map.Entry<String, Slot>> slots) {
        if (this._nc == null || this._waitForUseSuccess || this._waitingForOnSync) {
            return;
        }
        TCJavaSerializer js = new TCJavaSerializer(this._nc._objectEncoding);
        this.putHeader(js);
        if (this.putSlots(js, slots)) {
            TCMessage pMsg = new TCMessage();
            pMsg.setMsgID(19);
            pMsg.write(js.GetBuf(), js.GetPos());
            this._waitingForOnSync = true;
            this._nc._rtmpStream.queueMessage(pMsg);
        }
    }

    void updateServer(String slotName, Slot slot) {
        if (this._nc == null || this._waitForUseSuccess || this._waitingForOnSync) {
            return;
        }
        TCJavaSerializer js = new TCJavaSerializer(this._nc._objectEncoding);
        this.putHeader(js);
        if (this.putSlot(js, slotName, slot)) {
            TCMessage pMsg = new TCMessage();
            pMsg.setMsgID(19);
            pMsg.write(js.GetBuf(), js.GetPos());
            this._waitingForOnSync = true;
            this._nc._rtmpStream.queueMessage(pMsg);
        }
    }

    static {
        ON_SERVER_ONLY = new Storage(){

            @Override
            public Data load() {
                return null;
            }

            @Override
            public void store(Data data) {
            }

            @Override
            public void remove() {
            }
        };
        _illegalNames = new HashSet<String>();
        _illegalNames.add("connect");
        _illegalNames.add("send");
        _illegalNames.add("flush");
        _illegalNames.add("close");
        _illegalNames.add("getSize");
        _illegalNames.add("setFps");
        _illegalNames.add("onSync");
        _illegalNames.add("onStatus");
        _illegalNames.add("data");
        _illegalNames.add("deleteAll");
        _illegalNames.add("getDiskUsage");
        _sharedObjects = new HashMap<Handle, SharedObject>();
        _msgHandlers = new WeakHashMap<NetConnection, MessageHandler>();
    }

    class SyncInfoImpl
    implements SyncInfo {
        public String _code;
        public String _name;
        public Object _oldValue;

        @Override
        public String getCode() {
            return this._code;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Object getOldValue() {
            return this._oldValue;
        }

        public SyncInfoImpl(String code, String name, Object oldValue) {
            this._code = code;
            this._name = name;
            this._oldValue = oldValue;
        }

        public String toString() {
            return "{" + this._code + ", " + this._name + ", " + this._oldValue + "}";
        }
    }

    static class MessageHandler
    implements OnMessageHandler {
        Util.URI _remotePath;
        private int _objectEncoding = 0;

        public MessageHandler(Util.URI remotePath, int objectEncoding) {
            this._remotePath = remotePath;
            this._objectEncoding = objectEncoding;
        }

        @Override
        public boolean onMessage(Message m) {
            if (_log != null) {
                _log.info("Got container msg");
            }
            TCMessage msg = (TCMessage)m;
            TCJavaSerializer js = new TCJavaSerializer(msg.getMsgBuffer(), msg.getMsgLen(), this._objectEncoding);
            int endPos = js.GetPos() + msg.getMsgLen();
            String soname = js.GetString(2);
            int resetPos = js.GetPos();
            js.GetDWord();
            int flags = js.GetDWord();
            js.SetPos(resetPos);
            Handle h = new Handle(soname, this._remotePath, (flags & 2) != 0);
            SharedObject so = _sharedObjects.get(h);
            if (so != null) {
                so.processMessage(msg, js, endPos);
            }
            return true;
        }

        @Override
        public void onUnhandledMessage(Message m) {
        }
    }

    static class Handle {
        String _name = null;
        Util.URI _remotePath = null;
        boolean _persistent = false;

        Handle(String name, Util.URI remotePath, boolean persist) {
            this._name = name;
            this._remotePath = remotePath;
            this._persistent = persist;
        }

        boolean valid() {
            return this._name != null && this._remotePath != null;
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Handle)) {
                return false;
            }
            Handle other = (Handle)object;
            return this._name.equals(other._name) && this._remotePath.equalsIgnoreProto(other._remotePath) && this._persistent == other._persistent;
        }

        public String toString() {
            return "{" + this._name + ", " + this._remotePath + ", " + this._persistent + "}";
        }
    }

    public static interface Storage {
        public Data load();

        public void store(Data var1);

        public void remove();
    }

    public static class Data {
        public String name;
        public String path;
        public int magic;
        public long version;
        public Map<String, Slot> slots;

        public Data(String name, String path, int magic, long version, Map<String, Slot> slots) {
            this.name = name;
            this.path = path;
            this.magic = magic;
            this.version = version;
            this.slots = slots;
        }
    }

    public static class Slot
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -9138801207589819709L;
        public int state = 0;
        public Object value = null;

        Slot(int state, Object value) {
            this.state = state;
            this.value = value;
        }
    }
}

