/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.client;

import com.macromedia.fcs.client.NetConnection;
import com.macromedia.fcs.common.MessageDispatcher;
import com.macromedia.fcs.common.OnMessageHandler;
import com.macromedia.fcs.common.RtmpTransport;
import com.macromedia.fcs.shared.TCMessage;
import java.util.HashSet;
import java.util.Set;

public class NetStream {
    NetConnection _nc = null;
    MessageDispatcher _md = new MessageDispatcher();
    RtmpTransport.Stream _stream = null;
    double _bufsize = 0.1;
    double _buflen = 0.0;
    double _time = 0.0;
    static final Set<String> _reserved = new HashSet<String>();

    public NetStream(NetConnection nc) {
        this._nc = nc;
        this._stream = nc._rtmpTransport.createStream(this._md);
    }

    public void close() {
        RtmpTransport.Stream stream = this._stream;
        if (stream != null) {
            this._stream = null;
            stream.close();
        }
    }

    public boolean publish(String name, String type) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.publish(name, type);
    }

    public boolean send(String methodName, Object[] args) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.send(methodName, args);
    }

    public boolean sendMessage(double time, int type, byte[] message) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.sendMessage(new TCMessage(type, (long)(time * 1000.0), message));
    }

    public boolean play(String whatToPlay, double start, double length, boolean reset, boolean ignore) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.play(whatToPlay, start, length, reset, ignore);
    }

    public boolean play(String whatToPlay) {
        return this.play(whatToPlay, -2.0, -1.0, true, false);
    }

    public boolean seek(double offset) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.seek(offset);
    }

    public boolean pause(boolean pausePlay) {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return false;
        }
        return stream.pause(pausePlay);
    }

    public void receive(int type, boolean recv) {
        RtmpTransport.Stream stream = this._stream;
        if (stream != null) {
            stream.receive(type, recv);
        }
    }

    public void setBufferTime(double buftime) {
        RtmpTransport.Stream stream = this._stream;
        if (stream != null) {
            stream.setBufferTime(buftime);
        }
    }

    public double getBufferTime() {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return 0.0;
        }
        return stream.getBufferTime();
    }

    public double getBufferLength() {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return 0.0;
        }
        return stream.getBufferLength();
    }

    public double getCurrentFPS() {
        return 0.0;
    }

    public double getTime() {
        RtmpTransport.Stream stream = this._stream;
        if (stream == null) {
            return 0.0;
        }
        return stream.getTime();
    }

    public void registerSink(Object sink) {
        MessageDispatcher md = this._md;
        if (md != null) {
            md.registerSink(sink);
        }
    }

    public void unregisterSink(OnMessageHandler sink) {
        MessageDispatcher md = this._md;
        if (md != null) {
            md.unregisterSink(sink);
        }
    }

    static {
        _reserved.add("publish");
        _reserved.add("play");
        _reserved.add("receiveAudio");
        _reserved.add("receiveVideo");
        _reserved.add("pause");
        _reserved.add("seek");
        _reserved.add("close");
        _reserved.add("attachAudio");
        _reserved.add("attachVideo");
        _reserved.add("send");
        _reserved.add("call");
        _reserved.add("onStatus");
        _reserved.add("setBufferTime");
    }
}

