/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.fcs.client;

import com.macromedia.fcs.common.MessageDispatcher;
import com.macromedia.fcs.common.OnResultHandler;
import com.macromedia.fcs.common.RtmpTransport;
import com.macromedia.fcs.common.StatusInfo;
import com.macromedia.fcs.shared.TCCommand;
import com.macromedia.fcs.util.ThreadPool;
import com.macromedia.fcs.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetConnection {
    public static Map<String, Class> _name2ClassMap = new HashMap<String, Class>();
    public static Map<Class, String> _class2NameMap = new HashMap<Class, String>();
    String _uri = null;
    String _type = null;
    int _audioProps = 0;
    int _videoProps = 0;
    int _objectEncoding = 0;
    MessageDispatcher _messageDispatcher = new MessageDispatcher();
    RtmpTransport _rtmpTransport = null;
    RtmpTransport.Stream _rtmpStream = null;
    private static Logger _log;

    public NetConnection() {
        if (_log == null) {
            _log = LoggerFactory.getLogger(NetConnection.class);
        }
    }

    public NetConnection(String type) {
        this._type = type;
        if (_log == null) {
            _log = LoggerFactory.getLogger(NetConnection.class);
        }
    }

    public void SetAudioProps(int audioProps) {
        this._audioProps = audioProps;
    }

    public void SetVideoProps(int videoProps) {
        this._videoProps = videoProps;
    }

    public void SetObjectEncoding(int objectEncoding) {
        this._objectEncoding = objectEncoding;
    }

    public static void registerClass(String name, Class cls) {
        _name2ClassMap.put(name, cls);
        _class2NameMap.put(cls, name);
    }

    public static Class getRegisteredClass(String name) {
        return _name2ClassMap.get(name);
    }

    public static String getRegisteredName(Class cls) {
        return _class2NameMap.get(cls);
    }

    public static void unregisterClass(String name, Class cls) {
        _name2ClassMap.remove(name);
        _class2NameMap.remove(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String uristr, Object[] args) {
        NetConnection netConnection = this;
        synchronized (netConnection) {
            if (this._rtmpTransport != null) {
                _log.info("RTMP Transport already open, closing.");
                this._rtmpTransport.detach();
                this._rtmpTransport.close();
                this._rtmpTransport = null;
            }
            StringBuffer msg = new StringBuffer("Connecting to " + uristr);
            for (int i = 0; i < args.length; ++i) {
                msg.append(", " + args[i]);
            }
            msg.append(" Encoding: ").append(this._objectEncoding);
            _log.info(msg.toString());
            Util.URI uri = Util.parseURI(uristr);
            if (uri == null) {
                StatusInfo sinfo = new StatusInfo("error", "NetConnection.Connect.Failed", null, null);
                _log.warn("rtmpt/rtmps is not supported at the moment");
                this._messageDispatcher.dispatch(sinfo);
            } else {
                try {
                    this._rtmpTransport = new RtmpTransport(this._type);
                    this._rtmpStream = this._rtmpTransport.connect(uri, this._audioProps, this._videoProps, this._objectEncoding, args, this._messageDispatcher);
                }
                catch (Exception iox) {
                    iox.printStackTrace();
                    this._rtmpTransport.detach();
                    this._rtmpTransport = null;
                    StatusInfo sinfo = new StatusInfo("error", "NetConnection.Connect.Failed", null, null);
                    _log.error("NetConnection Connect Failed: " + iox.getMessage());
                    this._messageDispatcher.dispatch(sinfo);
                    return;
                }
            }
        }
    }

    public synchronized void close() {
        RtmpTransport rt = this._rtmpTransport;
        if (rt != null) {
            this._rtmpTransport = null;
            rt.close();
        }
    }

    public void call(String method, OnResultHandler orh, Object[] args) {
        RtmpTransport rt;
        RtmpTransport.Stream rs;
        TCCommand cmd = new TCCommand(this._objectEncoding);
        cmd.setMethodName(method);
        if ("ping".equalsIgnoreCase(method)) {
            cmd.setTrxID(this._messageDispatcher.registerPingResponseObject(orh));
        } else {
            cmd.setTrxID(this._messageDispatcher.registerResponseObject(orh));
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                cmd.setUserArg(args[i]);
            }
        }
        if ((rs = this._rtmpStream) != null) {
            rs.queueMessage(cmd.getCommandResponse());
        }
        if ((rt = this._rtmpTransport) != null) {
            rt.triggerWrite();
        }
    }

    public void registerSink(Object sink) {
        this._messageDispatcher.registerSink(sink);
    }

    public void unregisterSink(Object sink) {
        this._messageDispatcher.unregisterSink(sink);
    }

    public Util.URI getURI() {
        RtmpTransport rt = this._rtmpTransport;
        if (rt != null) {
            return rt.getURI();
        }
        return null;
    }

    public boolean isConnected() {
        RtmpTransport rt = this._rtmpTransport;
        if (rt != null) {
            return rt.isConnected();
        }
        return false;
    }

    public void connect(String uri) {
        this.connect(uri, new Object[0]);
    }

    public void connect(String uri, Object arg0) {
        this.connect(uri, new Object[]{arg0});
    }

    public void connect(String uri, Object arg0, Object arg1) {
        this.connect(uri, new Object[]{arg0, arg1});
    }

    public void connect(String uri, Object arg0, Object arg1, Object arg2) {
        this.connect(uri, new Object[]{arg0, arg1, arg2});
    }

    public void call(String method, OnResultHandler orh) {
        this.call(method, orh, new Object[0]);
    }

    public void call(String method, OnResultHandler orh, Object arg0) {
        this.call(method, orh, new Object[]{arg0});
    }

    public void call(String method, OnResultHandler orh, Object arg0, Object arg1) {
        this.call(method, orh, new Object[]{arg0, arg1});
    }

    public void call(String method, OnResultHandler orh, Object arg0, Object arg1, Object arg2) {
        this.call(method, orh, new Object[]{arg0, arg1, arg2});
    }

    public ThreadPool.Stats getStats(String which) {
        return this._rtmpTransport.getStats(which);
    }

    public String getVersion() {
        return "FCSj/1.13";
    }

    public static interface SupportVideoProps {
        public static final int SUPPORT_VID_UNUSED = 1;
        public static final int SUPPORT_VID_JPEG = 2;
        public static final int SUPPORT_VID_SORENSON = 4;
        public static final int SUPPORT_VID_HOMEBREW = 8;
        public static final int SUPPORT_VID_VP6 = 16;
        public static final int SUPPORT_VID_VP6ALPHA = 32;
        public static final int SUPPORT_VID_HOMEBREWV2 = 64;
        public static final int SUPPORT_VID_ALL = 127;
    }

    public static interface SupportSoundProps {
        public static final int SUPPORT_SND_NONE = 1;
        public static final int SUPPORT_SND_ADPCM = 2;
        public static final int SUPPORT_SND_MP3 = 4;
        public static final int SUPPORT_SND_INTEL = 8;
        public static final int SUPPORT_SND_UNUSED = 16;
        public static final int SUPPORT_SND_NELLY8 = 32;
        public static final int SUPPORT_SND_NELLY = 64;
        public static final int SUPPORT_SND_G711A = 128;
        public static final int SUPPORT_SND_G711U = 256;
        public static final int SUPPORT_SND_ALL = 511;
    }
}

